/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.IQRepository;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorContentProvider;
import eu.qimpress.ide.backbone.core.ui.QAppNavigatorLabelProvider;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesCheckBoxTreeViewer;
import eu.qimpress.ide.backbone.core.ui.widgets.QAlternativesTreeViewer;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IElementComparer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Composite;

public class QAlternativesTreeViewerFactory {
    private TreeViewer viewer;
    private SelectAlternativesEnum selectAlternatives;
    private static final IElementComparer ELEMENT_COMPARER = new QElementComparer();

    private QAlternativesTreeViewerFactory(TreeViewer viewer, SelectAlternativesEnum selectAlternatives) {
        this.viewer = viewer;
        this.selectAlternatives = selectAlternatives;
    }

    public static QAlternativesTreeViewerFactory createTreeViewer(Composite parent, SelectAlternativesEnum selectAlternatives) {
        Object alternativeViewer = null;
        alternativeViewer = selectAlternatives == SelectAlternativesEnum.NONE ? new QAlternativesTreeViewer(parent, 268438276) : new QAlternativesCheckBoxTreeViewer(parent, 268438276, selectAlternatives == SelectAlternativesEnum.SELECT_ONE);
        alternativeViewer.setContentProvider((IContentProvider)new QAppNavigatorContentProvider(QAppNavigatorContentProvider.ContentFilterEnum.FILTER_DEFAULT_ALTERNATIVE.val()));
        alternativeViewer.setLabelProvider((IBaseLabelProvider)new QAppNavigatorLabelProvider());
        alternativeViewer.setInput(QImpressApplicationModelManager.getManager().getQAppModel());
        alternativeViewer.setComparer(ELEMENT_COMPARER);
        alternativeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (element instanceof IQModel) {
                    return false;
                }
                return !(element instanceof IQAlternative) || !QImpressCore.isGlobalAlternative((IQAlternative)((IQAlternative)element));
            }
        });
        return new QAlternativesTreeViewerFactory((TreeViewer)alternativeViewer, selectAlternatives);
    }

    public QAlternativesTreeViewerFactory setParentAlternative(IQAlternative parentAlternative) {
        this.setParentAlternativeInternal((IQElement)parentAlternative);
        return this;
    }

    public QAlternativesTreeViewerFactory setParentAlternative(IQRepository repository) {
        this.setParentAlternativeInternal((IQElement)repository);
        return this;
    }

    public QAlternativesTreeViewerFactory setCanSelectQRepository(boolean canSelect) {
        switch (this.selectAlternatives) {
            case NONE: {
                break;
            }
            case SELECT_ONE: 
            case SELECT_MULTIPLE: {
                ((QAlternativesCheckBoxTreeViewer)this.viewer).setCanSelectRepository(canSelect);
                break;
            }
        }
        return this;
    }

    private void setParentAlternativeInternal(IQElement element) {
        if (element != null) {
            this.viewer.expandToLevel((Object)element, -1);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
            if (this.selectAlternatives != SelectAlternativesEnum.NONE) {
                ((CheckboxTreeViewer)this.viewer).setChecked((Object)element, true);
            }
        }
    }

    private void setParentElementInternal(IQElement element) {
        if (element != null) {
            this.viewer.expandToLevel((Object)element, 1);
            this.viewer.setSelection((ISelection)new StructuredSelection((Object)element), true);
            if (this.selectAlternatives != SelectAlternativesEnum.NONE) {
                ((CheckboxTreeViewer)this.viewer).setChecked((Object)element, true);
            }
        }
    }

    public QAlternativesTreeViewerFactory setParentElement(IQElement element) {
        if (element instanceof IQAlternative) {
            this.setParentAlternative((IQAlternative)element);
        } else {
            this.setParentElementInternal(element);
        }
        return this;
    }

    public TreeViewer getTreeViewer() {
        return this.viewer;
    }

    private static class QElementComparer
    implements IElementComparer {
        private QElementComparer() {
        }

        public boolean equals(Object a, Object b) {
            if (a == b) {
                return true;
            }
            if (a == null || b == null) {
                return false;
            }
            if (a instanceof IQProject) {
                a = ((IQProject)a).getProject();
            }
            if (b instanceof IQProject) {
                b = ((IQProject)b).getProject();
            }
            return a.equals(b);
        }

        public int hashCode(Object element) {
            if (element instanceof IQProject) {
                return ((IQProject)element).getProject().hashCode();
            }
            return element.hashCode();
        }
    }

    public static enum SelectAlternativesEnum {
        NONE,
        SELECT_ONE,
        SELECT_MULTIPLE;

    }
}

