/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.widgets;

import eu.qimpress.ide.backbone.core.ui.widgets.IWidgetFactory;
import java.lang.reflect.Constructor;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public abstract class AbstractWidgetFactory<T extends Viewer>
implements IWidgetFactory<T> {
    private static final Logger logger = Logger.getLogger(AbstractWidgetFactory.class);
    protected T widget;

    protected AbstractWidgetFactory(T widget) {
        this.widget = widget;
    }

    protected static <F extends AbstractWidgetFactory, W extends Viewer> F createWidgetFactory(Composite c, int style, Class<F> factoryClazz, Class<W> widgetClazz) {
        try {
            Constructor<W> wConstructor = widgetClazz.getDeclaredConstructor(Composite.class, Integer.TYPE);
            Viewer widget = (Viewer)wConstructor.newInstance(c, style);
            Constructor<F> fConstructor = factoryClazz.getDeclaredConstructor(widgetClazz);
            AbstractWidgetFactory factory = (AbstractWidgetFactory)fConstructor.newInstance(widget);
            factory.configureWidget();
            return (F)factory;
        }
        catch (Exception e) {
            logger.error((Object)"Cannot create widget factory", (Throwable)e);
            return null;
        }
    }

    protected abstract void configureWidget();

    protected abstract void finalizeWidget();

    @Override
    public T getWidget() {
        this.finalizeWidget();
        return this.widget;
    }
}

