/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.tabs;

import eu.qimpress.ide.backbone.core.QImpressCore;
import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQProject;
import eu.qimpress.ide.backbone.core.model.QImpressApplicationModelManager;
import eu.qimpress.ide.backbone.core.model.RepositoryException;
import eu.qimpress.ide.backbone.core.ui.tabs.IAlternativeSelection;
import eu.qimpress.ide.backbone.core.ui.widgets.UsageModelViewerFactory;
import eu.qimpress.ide.backbone.core.utils.SAMMModelsUtils;
import eu.qimpress.samm.usagemodel.UsageModel;
import org.apache.log4j.Logger;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class QImpressUsageModelSelectionTab
extends AbstractLaunchConfigurationTab
implements IAlternativeSelection {
    public static final String SELECTED_USAGE_MODEL_ID = "eu.qimpress.ide.backbone.core.ui.UsageModelSelection.id";
    public static final String SELECTED_USAGE_MODEL_PROJECT_NAME = "eu.qimpress.ide.backbone.core.ui.UsageModelSelection.project";
    public static final String SELECTED_USAGE_MODEL_ALTERNATIVE_ID = "eu.qimpress.ide.backbone.core.ui.UsageModelSelection.alternative.id";
    private static final Logger logger = Logger.getLogger(QImpressUsageModelSelectionTab.class);
    private static final boolean DEFAULT_VIEW_MODE_FLAT = false;
    private CheckboxTreeViewer usageModelViewer;
    private Label selectionText;
    private boolean usageModelsFlatMode = false;
    private IQAlternative selectedAlternative;

    public void createControl(Composite parent) {
        Composite myTabControl = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 5;
        gridLayout.marginHeight = 5;
        gridLayout.numColumns = 2;
        myTabControl.setLayout((Layout)gridLayout);
        this.setControl((Control)myTabControl);
        Group grpSelectUsageModel = new Group(myTabControl, 4);
        grpSelectUsageModel.setText("Select usage model");
        GridLayout selectorLayout = new GridLayout();
        selectorLayout.marginWidth = 5;
        selectorLayout.marginHeight = 5;
        selectorLayout.verticalSpacing = 0;
        selectorLayout.numColumns = 1;
        grpSelectUsageModel.setLayout((Layout)selectorLayout);
        grpSelectUsageModel.setLayoutData((Object)new GridData(4, 4, true, true, 2, 1));
        this.usageModelViewer = (CheckboxTreeViewer)UsageModelViewerFactory.createWidgetFactory((Composite)grpSelectUsageModel).getWidget();
        this.usageModelViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.usageModelViewer.expandAll();
        this.usageModelViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                QImpressUsageModelSelectionTab.this.setDirty(true);
                QImpressUsageModelSelectionTab.this.updateLaunchConfigurationDialog();
                QImpressUsageModelSelectionTab.this.updateCheckedItemLabelText();
            }
        });
        final Button filterSelectionButton = new Button((Composite)grpSelectUsageModel, 0x800002);
        filterSelectionButton.setText("Show all");
        filterSelectionButton.setLayoutData((Object)new GridData(131072, 1024, false, false, 1, 1));
        filterSelectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                QImpressUsageModelSelectionTab.this.enableFiltering(!filterSelectionButton.getSelection());
            }
        });
        Label selection = new Label(myTabControl, 0);
        selection.setText("Selected usage model: ");
        selection.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
        this.selectionText = new Label(myTabControl, 0);
        this.selectionText.setText("<none>");
        this.selectionText.setLayoutData((Object)new GridData(4, 4, false, false, 1, 1));
    }

    protected void updateCheckedItemLabelText() {
        Object[] checkedUsageModel = this.usageModelViewer.getCheckedElements();
        if (checkedUsageModel.length > 0 && checkedUsageModel[0] instanceof UsageModel) {
            this.selectionText.setText("'" + ((UsageModel)checkedUsageModel[0]).getName() + "' in '" + this.selectedAlternative.getInfo().getDescription() + "'");
        } else {
            this.selectionText.setText("<none>");
        }
    }

    public String getName() {
        return "Q-ImPrESS Usage Model";
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        String cfgUsageModelId = null;
        String cfgAlternativeId = null;
        String cfgProjectName = null;
        try {
            cfgUsageModelId = configuration.getAttribute(SELECTED_USAGE_MODEL_ID, null);
            cfgAlternativeId = configuration.getAttribute(SELECTED_USAGE_MODEL_ALTERNATIVE_ID, null);
            cfgProjectName = configuration.getAttribute(SELECTED_USAGE_MODEL_PROJECT_NAME, null);
            if (cfgUsageModelId != null && cfgAlternativeId != null && cfgProjectName != null) {
                if (this.selectedAlternative != null) {
                    if (this.selectedAlternative.getInfo().getId().equals(cfgAlternativeId) && this.usageModelsFlatMode || !this.usageModelsFlatMode) {
                        this.setUsageModelInView(this.selectedAlternative, cfgUsageModelId);
                    }
                } else if (this.selectedAlternative == null && !this.usageModelsFlatMode) {
                    this.initializeFormInternal(cfgUsageModelId, cfgAlternativeId, cfgProjectName);
                }
            }
        }
        catch (Exception e) {
            logger.warn((Object)"Cannot initialize usage model selection form", (Throwable)e);
        }
    }

    protected void initializeFormInternal(String usageModelId, String alternativeId, String projectName) throws RepositoryException {
        IQProject project = QImpressCore.getQProject((String)projectName);
        if (project == null) {
            return;
        }
        IQAlternative alternative = project.getRepository().getAlternative(alternativeId);
        if (alternative == null) {
            return;
        }
        this.setUsageModelInView(alternative, usageModelId);
    }

    protected void setUsageModelInView(IQAlternative alternative, String usageModelId) throws RepositoryException {
        UsageModel[] usageModels;
        SAMMModelsUtils.EnumModelLookup lookup = UsageModelViewerFactory.getModelLookup(this.usageModelViewer);
        UsageModel[] usageModelArray = usageModels = SAMMModelsUtils.getUsageModels((IQAlternative)alternative, (SAMMModelsUtils.EnumModelLookup)lookup);
        int n = usageModels.length;
        int n2 = 0;
        while (n2 < n) {
            UsageModel usageModel = usageModelArray[n2];
            if (usageModel.getId().equals(usageModelId)) {
                this.setSelectedAlternative(alternative);
                this.usageModelViewer.setChecked((Object)usageModel, true);
                this.updateCheckedItemLabelText();
                break;
            }
            ++n2;
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        Object[] elements = this.usageModelViewer.getCheckedElements();
        if (elements.length != 1 || !(elements[0] instanceof UsageModel)) {
            configuration.setAttribute(SELECTED_USAGE_MODEL_ID, "");
        } else {
            UsageModel selectedUsageModel = (UsageModel)elements[0];
            configuration.setAttribute(SELECTED_USAGE_MODEL_ID, selectedUsageModel.getId());
            configuration.setAttribute(SELECTED_USAGE_MODEL_ALTERNATIVE_ID, QImpressCore.getAlternativeId((URI)selectedUsageModel.eResource().getURI()));
            String projectName = QImpressCore.getQProject((EObject)selectedUsageModel).getProject().getName();
            configuration.setAttribute(SELECTED_USAGE_MODEL_PROJECT_NAME, projectName);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(SELECTED_USAGE_MODEL_ID, null);
        configuration.setAttribute(SELECTED_USAGE_MODEL_ALTERNATIVE_ID, null);
        configuration.setAttribute(SELECTED_USAGE_MODEL_PROJECT_NAME, null);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        return this.validatePage();
    }

    protected boolean validatePage() {
        Object[] selectedObject = this.usageModelViewer.getCheckedElements();
        if (selectedObject.length != 1) {
            this.setErrorMessage("Usage model has to be selected");
            return false;
        }
        return true;
    }

    @Override
    public void setSelectedAlternative(IQAlternative alternative) {
        if (alternative != this.selectedAlternative) {
            this.selectedAlternative = alternative;
            if (this.usageModelsFlatMode) {
                this.usageModelViewer.setInput((Object)alternative);
            } else {
                this.usageModelViewer.setInput((Object)QImpressApplicationModelManager.getManager().getQAppModel());
            }
            this.enableFiltering(this.selectedAlternative != null);
            this.usageModelViewer.expandAll();
            this.setDirty(true);
        }
    }

    public void setFlatViewMode(boolean mode) {
        this.usageModelsFlatMode = mode;
        UsageModelViewerFactory.setFlatViewMode(mode, this.usageModelViewer);
    }

    public UsageModel getSelectedUsageModel() {
        Object[] selectedObject = this.usageModelViewer.getCheckedElements();
        if (selectedObject.length == 1) {
            return (UsageModel)selectedObject[0];
        }
        return null;
    }

    protected void enableFiltering(boolean enable) {
        if (enable && this.selectedAlternative != null) {
            UsageModelViewerFactory.applyFilterFor(this.selectedAlternative, this.usageModelViewer);
        } else {
            this.usageModelViewer.resetFilters();
        }
    }
}

