/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.backbone.core.ui.internal;

import eu.qimpress.ide.backbone.core.model.IQAlternative;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.QElementResourceMapping;
import eu.qimpress.ide.backbone.core.ui.internal.QAppWorkbenchAdapter;
import eu.qimpress.ide.backbone.core.ui.internal.properties.QAlternativeInfoPropertySource;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.ui.IContributorResourceAdapter;
import org.eclipse.ui.ide.IContributorResourceAdapter2;
import org.eclipse.ui.model.IWorkbenchAdapter;
import org.eclipse.ui.views.properties.IPropertySource;

public class QAppElementAdapterFactory
implements IAdapterFactory,
IContributorResourceAdapter,
IContributorResourceAdapter2 {
    private static final Class[] SUPPORTED_ADAPTERS = new Class[]{IResource.class, IWorkbenchAdapter.class, IContributorResourceAdapter.class, IContributorResourceAdapter2.class, IWorkbenchAdapter.class, IPropertySource.class};
    private QAppWorkbenchAdapter qAppWorkbenchAdapter;

    public Object getAdapter(Object adaptableObject, Class adapterType) {
        IQElement element = this.getQAppElement(adaptableObject);
        if (IResource.class.equals((Object)adapterType)) {
            return this.getResource(element);
        }
        if (IContributorResourceAdapter.class.equals((Object)adapterType)) {
            return this;
        }
        if (IContributorResourceAdapter2.class.equals((Object)adapterType)) {
            return this;
        }
        if (IWorkbenchAdapter.class.equals((Object)adapterType)) {
            return this.getQAppWorkbenchAdaper();
        }
        if (IPropertySource.class.equals((Object)adapterType)) {
            return this.getPropertySource(element);
        }
        return null;
    }

    private IPropertySource getPropertySource(IQElement element) {
        if (element.getElementType() == IQElement.ElementType.Q_ALTERNATIVE) {
            return new QAlternativeInfoPropertySource(((IQAlternative)element).getInfo());
        }
        return null;
    }

    private IWorkbenchAdapter getQAppWorkbenchAdaper() {
        if (this.qAppWorkbenchAdapter == null) {
            this.qAppWorkbenchAdapter = new QAppWorkbenchAdapter();
        }
        return this.qAppWorkbenchAdapter;
    }

    private IResource getResource(IQElement element) {
        return element.getCorrespondingResource();
    }

    private IQElement getQAppElement(Object adaptableObject) {
        if (adaptableObject instanceof IQElement) {
            return (IQElement)adaptableObject;
        }
        if (adaptableObject instanceof IAdaptable) {
            return (IQElement)((IAdaptable)adaptableObject).getAdapter(IQElement.class);
        }
        return null;
    }

    public Class[] getAdapterList() {
        return SUPPORTED_ADAPTERS;
    }

    public IResource getAdaptedResource(IAdaptable adaptable) {
        IQElement element = this.getQAppElement(adaptable);
        if (element != null) {
            return this.getResource(element);
        }
        return null;
    }

    public ResourceMapping getAdaptedResourceMapping(IAdaptable adaptable) {
        IQElement element = this.getQAppElement(adaptable);
        if (element != null) {
            return QElementResourceMapping.create((IQElement)element);
        }
        return null;
    }
}

