/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep.function;

import java.util.Stack;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;
import org.nfunk.jep.type.Complex;

public class Power
extends PostfixMathCommand {
    public Power() {
        this.numberOfParameters = 2;
    }

    public void run(Stack inStack) throws ParseException {
        this.checkStack(inStack);
        Object param2 = inStack.pop();
        Object param1 = inStack.pop();
        inStack.push(this.power(param1, param2));
    }

    public Object power(Object param1, Object param2) throws ParseException {
        if (param1 instanceof Complex) {
            if (param2 instanceof Complex) {
                return this.power((Complex)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.power((Complex)param1, (Number)param2);
            }
        } else if (param1 instanceof Number) {
            if (param2 instanceof Complex) {
                return this.power((Number)param1, (Complex)param2);
            }
            if (param2 instanceof Number) {
                return this.power((Number)param1, (Number)param2);
            }
        }
        throw new ParseException("Invalid parameter type");
    }

    public Object power(Number d1, Number d2) {
        short ival = d2.shortValue();
        double dval = d2.doubleValue();
        if (d1.doubleValue() < 0.0 && dval != (double)ival) {
            Complex c = new Complex(d1.doubleValue(), 0.0);
            return c.power(d2.doubleValue());
        }
        if (dval == (double)ival) {
            if (dval >= 0.0) {
                return new Double(this.power(d1.doubleValue(), (int)ival));
            }
            return new Double(1.0 / this.power(d1.doubleValue(), (int)(-ival)));
        }
        return new Double(Math.pow(d1.doubleValue(), d2.doubleValue()));
    }

    public Object power(Complex c1, Complex c2) {
        Complex temp = c1.power(c2);
        if (temp.im() == 0.0) {
            return new Double(temp.re());
        }
        return temp;
    }

    public Object power(Complex c, Number d) {
        Complex temp = c.power(d.doubleValue());
        if (temp.im() == 0.0) {
            return new Double(temp.re());
        }
        return temp;
    }

    public Object power(Number d, Complex c) {
        Complex base = new Complex(d.doubleValue(), 0.0);
        Complex temp = base.power(c);
        if (temp.im() == 0.0) {
            return new Double(temp.re());
        }
        return temp;
    }

    public double power(double x, int n) {
        switch (n) {
            case 0: {
                x = 1.0;
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                x *= x;
                break;
            }
            case 3: {
                x *= x * x;
                break;
            }
            case 4: {
                x *= x * x * x;
                break;
            }
            case 5: {
                x *= x * x * x * x;
                break;
            }
            case 6: {
                x *= x * x * x * x * x;
                break;
            }
            case 7: {
                x *= x * x * x * x * x * x;
                break;
            }
            case 8: {
                x *= x * x * x * x * x * x * x;
                break;
            }
            default: {
                int bitMask = n;
                double evenPower = x;
                double result = (bitMask & 1) != 0 ? x : 1.0;
                bitMask >>>= 1;
                while (bitMask != 0) {
                    evenPower *= evenPower;
                    if ((bitMask & 1) != 0) {
                        result *= evenPower;
                    }
                    bitMask >>>= 1;
                }
                x = result;
            }
        }
        return x;
    }
}

