/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import org.nfunk.jep.Operator;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Assign;
import org.nfunk.jep.function.Comparative;
import org.nfunk.jep.function.Cross;
import org.nfunk.jep.function.Divide;
import org.nfunk.jep.function.Dot;
import org.nfunk.jep.function.Ele;
import org.nfunk.jep.function.List;
import org.nfunk.jep.function.Logical;
import org.nfunk.jep.function.Modulus;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.Not;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Power;
import org.nfunk.jep.function.Subtract;
import org.nfunk.jep.function.UMinus;

public class OperatorSet {
    protected Operator OP_GT = new Operator(">", (PostfixMathCommandI)new Comparative(1));
    protected Operator OP_LT = new Operator("<", (PostfixMathCommandI)new Comparative(0));
    protected Operator OP_EQ = new Operator("==", (PostfixMathCommandI)new Comparative(5));
    protected Operator OP_LE = new Operator("<=", (PostfixMathCommandI)new Comparative(2));
    protected Operator OP_GE = new Operator(">=", (PostfixMathCommandI)new Comparative(3));
    protected Operator OP_NE = new Operator("!=", (PostfixMathCommandI)new Comparative(4));
    protected Operator OP_AND = new Operator("&&", (PostfixMathCommandI)new Logical(0));
    protected Operator OP_OR = new Operator("||", (PostfixMathCommandI)new Logical(1));
    protected Operator OP_NOT = new Operator("!", (PostfixMathCommandI)new Not());
    protected Operator OP_ADD = new Operator("+", (PostfixMathCommandI)new Add());
    protected Operator OP_SUBTRACT = new Operator("-", (PostfixMathCommandI)new Subtract());
    protected Operator OP_UMINUS = new Operator("UMinus", "-", (PostfixMathCommandI)new UMinus());
    protected Operator OP_MULTIPLY = new Operator("*", (PostfixMathCommandI)new Multiply());
    protected Operator OP_DIVIDE = new Operator("/", (PostfixMathCommandI)new Divide());
    protected Operator OP_MOD = new Operator("%", (PostfixMathCommandI)new Modulus());
    protected Operator OP_UDIVIDE = new Operator("UDivide", "^-1", null);
    protected Operator OP_POWER = new Operator("^", (PostfixMathCommandI)new Power());
    protected Operator OP_ASSIGN = new Operator("=", (PostfixMathCommandI)new Assign());
    protected Operator OP_DOT = new Operator(".", (PostfixMathCommandI)new Dot());
    protected Operator OP_CROSS = new Operator("^^", (PostfixMathCommandI)new Cross());
    protected Operator OP_LIST = new Operator("LIST", (PostfixMathCommandI)new List());
    protected Operator OP_ELEMENT = new Operator("[]", (PostfixMathCommandI)new Ele());

    public Operator[] getOperators() {
        Operator[] ops = new Operator[]{this.OP_GT, this.OP_LT, this.OP_GE, this.OP_LE, this.OP_EQ, this.OP_NE, this.OP_AND, this.OP_OR, this.OP_NOT, this.OP_ADD, this.OP_SUBTRACT, this.OP_UMINUS, this.OP_MULTIPLY, this.OP_DIVIDE, this.OP_MOD, this.OP_POWER, this.OP_ASSIGN, this.OP_DOT, this.OP_CROSS, this.OP_LIST, this.OP_ELEMENT};
        return ops;
    }

    public void printOperators() {
        Operator[] ops = this.getOperators();
        int i = 0;
        while (i < ops.length) {
            System.out.println(ops[i].toString());
            ++i;
        }
    }

    public Operator getAdd() {
        return this.OP_ADD;
    }

    public Operator getSubtract() {
        return this.OP_SUBTRACT;
    }

    public Operator getUMinus() {
        return this.OP_UMINUS;
    }

    public Operator getMultiply() {
        return this.OP_MULTIPLY;
    }

    public Operator getDivide() {
        return this.OP_DIVIDE;
    }

    public Operator getMod() {
        return this.OP_MOD;
    }

    public Operator getPower() {
        return this.OP_POWER;
    }

    public Operator getEQ() {
        return this.OP_EQ;
    }

    public Operator getNE() {
        return this.OP_NE;
    }

    public Operator getGE() {
        return this.OP_GE;
    }

    public Operator getGT() {
        return this.OP_GT;
    }

    public Operator getLE() {
        return this.OP_LE;
    }

    public Operator getLT() {
        return this.OP_LT;
    }

    public Operator getAnd() {
        return this.OP_AND;
    }

    public Operator getOr() {
        return this.OP_OR;
    }

    public Operator getNot() {
        return this.OP_NOT;
    }

    public Operator getAssign() {
        return this.OP_ASSIGN;
    }

    public Operator getDot() {
        return this.OP_DOT;
    }

    public Operator getCross() {
        return this.OP_CROSS;
    }

    public Operator getList() {
        return this.OP_LIST;
    }

    public Operator getElement() {
        return this.OP_ELEMENT;
    }
}

