/*
 * Decompiled with CFR 0.152.
 */
package org.nfunk.jep;

import java.io.Reader;
import java.io.StringReader;
import java.util.Vector;
import org.nfunk.jep.EvaluatorI;
import org.nfunk.jep.EvaluatorVisitor;
import org.nfunk.jep.FunctionTable;
import org.nfunk.jep.Node;
import org.nfunk.jep.OperatorSet;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Parser;
import org.nfunk.jep.ParserDumpVisitor;
import org.nfunk.jep.ParserVisitor;
import org.nfunk.jep.SymbolTable;
import org.nfunk.jep.Variable;
import org.nfunk.jep.VariableFactory;
import org.nfunk.jep.function.Abs;
import org.nfunk.jep.function.ArcCosine;
import org.nfunk.jep.function.ArcCosineH;
import org.nfunk.jep.function.ArcSine;
import org.nfunk.jep.function.ArcSineH;
import org.nfunk.jep.function.ArcTanH;
import org.nfunk.jep.function.ArcTangent;
import org.nfunk.jep.function.ArcTangent2;
import org.nfunk.jep.function.Arg;
import org.nfunk.jep.function.Binomial;
import org.nfunk.jep.function.ComplexPFMC;
import org.nfunk.jep.function.Conjugate;
import org.nfunk.jep.function.Cosine;
import org.nfunk.jep.function.CosineH;
import org.nfunk.jep.function.Exp;
import org.nfunk.jep.function.If;
import org.nfunk.jep.function.Imaginary;
import org.nfunk.jep.function.Logarithm;
import org.nfunk.jep.function.Modulus;
import org.nfunk.jep.function.NaturalLogarithm;
import org.nfunk.jep.function.Polar;
import org.nfunk.jep.function.PostfixMathCommandI;
import org.nfunk.jep.function.Power;
import org.nfunk.jep.function.Random;
import org.nfunk.jep.function.Real;
import org.nfunk.jep.function.Sine;
import org.nfunk.jep.function.SineH;
import org.nfunk.jep.function.SquareRoot;
import org.nfunk.jep.function.Str;
import org.nfunk.jep.function.Sum;
import org.nfunk.jep.function.TanH;
import org.nfunk.jep.function.Tangent;
import org.nfunk.jep.type.Complex;
import org.nfunk.jep.type.DoubleNumberFactory;
import org.nfunk.jep.type.NumberFactory;

public class JEP {
    private static final boolean debug = false;
    private boolean traverse;
    protected boolean allowUndeclared;
    protected boolean allowAssignment;
    protected boolean implicitMul;
    protected SymbolTable symTab;
    protected FunctionTable funTab;
    protected Vector errorList;
    protected Parser parser;
    private Node topNode = null;
    protected EvaluatorVisitor ev;
    protected NumberFactory numberFactory;
    protected OperatorSet opSet;

    public JEP() {
        this.traverse = false;
        this.allowUndeclared = false;
        this.allowAssignment = false;
        this.implicitMul = false;
        this.numberFactory = new DoubleNumberFactory();
        this.opSet = new OperatorSet();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor(this.getSymbolTable());
        this.parser = new Parser((Reader)new StringReader(""));
    }

    public JEP(boolean traverse_in, boolean allowUndeclared_in, boolean implicitMul_in, NumberFactory numberFactory_in) {
        this.traverse = traverse_in;
        this.allowUndeclared = allowUndeclared_in;
        this.implicitMul = implicitMul_in;
        this.numberFactory = numberFactory_in == null ? new DoubleNumberFactory() : numberFactory_in;
        this.opSet = new OperatorSet();
        this.initSymTab();
        this.initFunTab();
        this.errorList = new Vector();
        this.ev = new EvaluatorVisitor(this.getSymbolTable());
        this.parser = new Parser((Reader)new StringReader(""));
        this.parseExpression("");
    }

    protected JEP(JEP j) {
        this.traverse = j.traverse;
        this.allowUndeclared = j.allowUndeclared;
        this.allowAssignment = j.allowAssignment;
        this.implicitMul = j.implicitMul;
        this.ev = j.ev;
        this.funTab = j.funTab;
        this.opSet = j.opSet;
        this.numberFactory = j.numberFactory;
        this.parser = j.parser;
        this.symTab = j.symTab;
        this.errorList = j.errorList;
    }

    public void initSymTab() {
        this.symTab = new SymbolTable(new VariableFactory());
    }

    public void initFunTab() {
        this.funTab = new FunctionTable();
    }

    public void addStandardFunctions() {
        this.funTab.put("sin", (PostfixMathCommandI)new Sine());
        this.funTab.put("cos", (PostfixMathCommandI)new Cosine());
        this.funTab.put("tan", (PostfixMathCommandI)new Tangent());
        this.funTab.put("asin", (PostfixMathCommandI)new ArcSine());
        this.funTab.put("acos", (PostfixMathCommandI)new ArcCosine());
        this.funTab.put("atan", (PostfixMathCommandI)new ArcTangent());
        this.funTab.put("atan2", (PostfixMathCommandI)new ArcTangent2());
        this.funTab.put("sinh", (PostfixMathCommandI)new SineH());
        this.funTab.put("cosh", (PostfixMathCommandI)new CosineH());
        this.funTab.put("tanh", (PostfixMathCommandI)new TanH());
        this.funTab.put("asinh", (PostfixMathCommandI)new ArcSineH());
        this.funTab.put("acosh", (PostfixMathCommandI)new ArcCosineH());
        this.funTab.put("atanh", (PostfixMathCommandI)new ArcTanH());
        this.funTab.put("log", (PostfixMathCommandI)new Logarithm());
        this.funTab.put("ln", (PostfixMathCommandI)new NaturalLogarithm());
        this.funTab.put("exp", (PostfixMathCommandI)new Exp());
        this.funTab.put("pow", (PostfixMathCommandI)new Power());
        this.funTab.put("sqrt", (PostfixMathCommandI)new SquareRoot());
        this.funTab.put("abs", (PostfixMathCommandI)new Abs());
        this.funTab.put("mod", (PostfixMathCommandI)new Modulus());
        this.funTab.put("sum", (PostfixMathCommandI)new Sum());
        this.funTab.put("rand", (PostfixMathCommandI)new Random());
        this.funTab.put("if", (PostfixMathCommandI)new If());
        this.funTab.put("str", (PostfixMathCommandI)new Str());
        this.funTab.put("binom", (PostfixMathCommandI)new Binomial());
    }

    public void addStandardConstants() {
        this.symTab.addConstant("pi", (Object)new Double(Math.PI));
        this.symTab.addConstant("e", (Object)new Double(Math.E));
    }

    public void addComplex() {
        this.symTab.addConstant("i", (Object)new Complex(0.0, 1.0));
        this.funTab.put("re", (PostfixMathCommandI)new Real());
        this.funTab.put("im", (PostfixMathCommandI)new Imaginary());
        this.funTab.put("arg", (PostfixMathCommandI)new Arg());
        this.funTab.put("cmod", (PostfixMathCommandI)new Abs());
        this.funTab.put("complex", (PostfixMathCommandI)new ComplexPFMC());
        this.funTab.put("polar", (PostfixMathCommandI)new Polar());
        this.funTab.put("conj", (PostfixMathCommandI)new Conjugate());
    }

    public void addFunction(String functionName, PostfixMathCommandI function) {
        this.funTab.put(functionName, function);
    }

    public void addConstant(String name, Object value) {
        this.symTab.addConstant(name, value);
    }

    public Double addVariable(String name, double value) {
        Double object = new Double(value);
        this.symTab.makeVarIfNeeded(name, (Object)object);
        return object;
    }

    public Complex addVariable(String name, double re, double im) {
        Complex object = new Complex(re, im);
        this.symTab.makeVarIfNeeded(name, (Object)object);
        return object;
    }

    public void addVariable(String name, Object object) {
        this.symTab.makeVarIfNeeded(name, object);
    }

    public Object removeVariable(String name) {
        return this.symTab.remove((Object)name);
    }

    public Object getVarValue(String name) {
        return this.symTab.getVar(name).getValue();
    }

    public void setVarValue(String name, Object val) {
        this.symTab.setVarValue(name, val);
    }

    public Variable getVar(String name) {
        return this.symTab.getVar(name);
    }

    public Object removeFunction(String name) {
        return this.funTab.remove((Object)name);
    }

    public void setTraverse(boolean value) {
        this.traverse = value;
    }

    public boolean getTraverse() {
        return this.traverse;
    }

    public void setImplicitMul(boolean value) {
        this.implicitMul = value;
    }

    public boolean getImplicitMul() {
        return this.implicitMul;
    }

    public void setAllowUndeclared(boolean value) {
        this.allowUndeclared = value;
    }

    public boolean getAllowUndeclared() {
        return this.allowUndeclared;
    }

    public void setAllowAssignment(boolean value) {
        this.allowAssignment = value;
    }

    public boolean getAllowAssignment() {
        return this.allowAssignment;
    }

    public void parseExpression(String expression_in) {
        StringReader reader = new StringReader(expression_in);
        try {
            this.errorList.removeAllElements();
            this.topNode = this.parser.parseStream((Reader)reader, this);
        }
        catch (Throwable e) {
            this.topNode = null;
            if (e instanceof ParseException) {
                this.errorList.addElement(((ParseException)e).getMessage());
            }
            this.errorList.addElement("Syntax error");
        }
        if (this.traverse && !this.hasError()) {
            ParserDumpVisitor v = new ParserDumpVisitor();
            try {
                this.topNode.jjtAccept((ParserVisitor)v, null);
            }
            catch (ParseException e) {
                this.errorList.addElement(e.getMessage());
            }
        }
    }

    public Node parse(String expression) throws ParseException {
        StringReader sr = new StringReader(expression);
        this.errorList.removeAllElements();
        Node node = this.parser.parseStream((Reader)sr, this);
        if (this.hasError()) {
            throw new ParseException(this.getErrorInfo());
        }
        return node;
    }

    public Object evaluate(Node node) throws ParseException {
        return this.ev.getValue(node, this.symTab);
    }

    public double getValue() {
        Object value = this.getValueAsObject();
        if (value == null) {
            return Double.NaN;
        }
        if (value instanceof Complex) {
            Complex c = (Complex)value;
            if (c.im() != 0.0) {
                return Double.NaN;
            }
            return c.re();
        }
        if (value != null && value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        return Double.NaN;
    }

    public Complex getComplexValue() {
        Object value = this.getValueAsObject();
        if (value == null) {
            return null;
        }
        if (value instanceof Complex) {
            return (Complex)value;
        }
        if (value instanceof Number) {
            return new Complex(((Number)value).doubleValue(), 0.0);
        }
        return null;
    }

    public Object getValueAsObject() {
        Object result;
        if (this.topNode == null || this.hasError()) {
            return null;
        }
        try {
            result = this.ev.getValue(this.topNode, this.symTab);
        }
        catch (ParseException e) {
            this.errorList.addElement("Error during evaluation: " + e.getMessage());
            return null;
        }
        catch (RuntimeException e) {
            this.errorList.addElement(String.valueOf(e.getClass().getName()) + ": " + e.getMessage());
            return null;
        }
        return result;
    }

    public boolean hasError() {
        return !this.errorList.isEmpty();
    }

    public String getErrorInfo() {
        if (this.hasError()) {
            String str = "";
            int i = 0;
            while (i < this.errorList.size()) {
                str = String.valueOf(str) + this.errorList.elementAt(i) + "\n";
                ++i;
            }
            return str;
        }
        return null;
    }

    public Node getTopNode() {
        return this.topNode;
    }

    public SymbolTable getSymbolTable() {
        return this.symTab;
    }

    public FunctionTable getFunctionTable() {
        return this.funTab;
    }

    public EvaluatorI getEvaluatorVisitor() {
        return this.ev;
    }

    public NumberFactory getNumberFactory() {
        return this.numberFactory;
    }

    public OperatorSet getOperatorSet() {
        return this.opSet;
    }

    public Parser getParser() {
        return this.parser;
    }
}

