/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.jepgraph;

import java.awt.geom.Point2D;
import org.lsmp.jepgraph.GraphDomainI;

public class PolarDomain
implements GraphDomainI {
    double rmax;

    public PolarDomain(double rmax) {
        this.rmax = rmax;
    }

    public double getXmin() {
        return 0.0;
    }

    public double getXmax() {
        return this.rmax;
    }

    public double getYmin() {
        return -Math.PI;
    }

    public double getYmax() {
        return Math.PI;
    }

    public boolean isPlottablePoint(Point2D point) {
        double y;
        double x = point.getX();
        double r = Math.hypot(x, y = point.getX());
        return r >= 0.0 && r <= this.rmax;
    }

    public Point2D sourceToTarget(Point2D src) {
        double r = src.getX();
        double th = src.getY();
        double x = r * Math.cos(th);
        double y = r * Math.sin(th);
        return new Point2D.Double(x, y);
    }

    public Point2D targetToSource(Point2D tgt) {
        double x = tgt.getX();
        double y = tgt.getY();
        double r = Math.hypot(x, y);
        double th = Math.atan2(y, x);
        return new Point2D.Double(r, th);
    }

    public boolean isLegal(Point2D p) {
        double y;
        double x = p.getX();
        double r = Math.hypot(x, y = p.getY());
        return r >= 0.0;
    }

    public Point2D firstDerivative(Point2D vec) {
        return vec;
    }
}

