/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.jepgraph;

import java.awt.geom.Point2D;
import org.lsmp.djep.djep.DJep;
import org.lsmp.djep.djep.DVariable;
import org.lsmp.jepgraph.GraphFunctionI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class JepGraphFunction
implements GraphFunctionI {
    DJep j;
    Node expression;
    Node derivative;
    DVariable var;

    public JepGraphFunction(DJep j, Node expression, DVariable var) throws ParseException {
        this.j = j;
        this.expression = expression;
        this.var = var;
        this.derivative = j.differentiate(expression, var.getName());
    }

    public double y(double x) {
        double res;
        this.var.setValue((Object)new Double(x));
        try {
            Object o = this.j.evaluate(this.expression);
            res = (Double)o;
        }
        catch (ParseException e) {
            res = Double.NaN;
        }
        return res;
    }

    public Point2D yAsPoint(double x) {
        double y = this.y(x);
        return new Point2D.Double(x, y);
    }

    public double dydx(double x) {
        double res;
        this.var.setValue((Object)new Double(x));
        try {
            Object o = this.j.evaluate(this.derivative);
            res = (Double)o;
        }
        catch (ParseException e) {
            res = Double.NaN;
        }
        return res;
    }
}

