/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepJUnit;

import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestResult;
import junit.framework.TestSuite;
import org.lsmp.djep.rpe.RpCommandList;
import org.lsmp.djep.rpe.RpEval;
import org.lsmp.djep.xjep.XJep;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.type.Complex;

/*
 * Exception performing whole class analysis ignored.
 */
public class RpTest
extends TestCase {
    JEP j;
    public static final boolean SHOW_BAD = false;
    String[][] matStrs = new String[10][10];
    String[] vecStrs = new String[10];
    boolean TESTALL = false;
    static /* synthetic */ Class class$0;

    public RpTest(String name) {
        super(name);
    }

    public static void main(String[] args) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.RpTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        TestSuite suite = new TestSuite((Class)clazz);
        suite.run(new TestResult());
    }

    protected void setUp() {
        this.j = new XJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowAssignment(true);
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
    }

    public static Test suite() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.lsmp.djepJUnit.RpTest");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return new TestSuite((Class)clazz);
    }

    public void testGood() {
        RpTest.assertEquals((int)1, (int)1);
    }

    public void myAssertEquals(String msg, String actual, String expected) {
        if (!actual.equals(expected)) {
            System.out.println("Error \"" + msg + "\" is \n<" + actual + "> should be \n<" + expected + ">");
        }
        RpTest.assertEquals((String)("<" + msg + ">"), (Object)expected, (Object)actual);
        System.out.println("Success: Value of <" + msg + "> is <" + actual + ">");
    }

    public void valueTest(String expr, double dub) throws ParseException, Exception {
        this.valueTest(expr, (Object)new Double(dub));
    }

    public void valueTest(String expr, Object expected) throws ParseException, Exception {
        Node node = this.j.parse(expr);
        Object res = this.j.evaluate(node);
        if (this.j.hasError()) {
            RpTest.fail((String)("Evaluation Failure: " + expr + this.j.getErrorInfo()));
        }
        RpTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res);
        System.out.println("Sucess value of <" + expr + "> is " + res);
    }

    public void valueTest(String expr, String expected) throws ParseException, Exception {
        Node node = this.j.parse(expr);
        Object res = this.j.evaluate(node);
        if (this.j.hasError()) {
            RpTest.fail((String)("Evaluation Failure: " + expr + this.j.getErrorInfo()));
        }
        RpTest.assertEquals((String)("<" + expr + ">"), (Object)expected, (Object)res.toString());
        System.out.println("Sucess value of <" + expr + "> is " + res.toString());
    }

    public void complexValueTest(String expr, Complex expected, double tol) throws Exception {
        Node node = this.j.parse(expr);
        Object res = this.j.evaluate(node);
        RpTest.assertTrue((String)("<" + expr + "> expected: <" + expected + "> but was <" + res + ">"), (boolean)expected.equals((Complex)res, tol));
        System.out.println("Sucess value of <" + expr + "> is " + res);
    }

    public Object calcValue(String expr) throws ParseException, Exception {
        Node node = this.j.parse(expr);
        Object res = this.j.evaluate(node);
        return res;
    }

    void rpTest(String[] eqns, String eqn2) throws ParseException, Exception {
        int i = 0;
        while (i < eqns.length) {
            System.out.println("eqns " + eqns[i]);
            Node node = this.j.parse(eqns[i]);
            this.j.evaluate(node);
            ++i;
        }
        Node node3 = this.j.parse(eqn2);
        RpEval rpe = new RpEval(this.j);
        RpCommandList list = rpe.compile(node3);
        double rpRes = rpe.evaluate(list);
        Object matRes = this.j.evaluate(node3);
        if (this.j.hasError()) {
            RpTest.fail((String)("Evaluation Failure: " + eqn2 + this.j.getErrorInfo()));
        }
        this.myAssertEquals("<" + eqn2 + ">", "" + rpRes, matRes.toString());
        if (!matRes.equals(new Double(rpRes))) {
            RpTest.fail((String)("Expected <" + matRes + "> found <" + rpRes + ">"));
        }
    }

    void rpTest2(String[] eqns) throws ParseException, Exception {
        Node[] nodes = new Node[eqns.length];
        double[] rpRes = new double[eqns.length];
        RpEval rpe = new RpEval(this.j);
        int i = 0;
        while (i < eqns.length) {
            System.out.println("eqns " + eqns[i]);
            nodes[i] = this.j.parse(eqns[i]);
            RpCommandList list = rpe.compile(nodes[i]);
            rpRes[i] = rpe.evaluate(list);
            System.out.println("<" + eqns[i] + "> " + rpRes[i]);
            ++i;
        }
        i = 0;
        while (i < eqns.length) {
            Object matRes = this.j.evaluate(nodes[i]);
            if (!matRes.equals(new Double(rpRes[i]))) {
                RpTest.fail((String)("Expected <" + matRes + "> found <" + rpRes[i] + ">"));
            }
            ++i;
        }
        rpe.cleanUp();
    }

    public void testRp() throws ParseException, Exception {
        this.rpTest(new String[0], "1*2*3+4*5*6+7*8*9");
        this.rpTest(new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9"}, "x1*x2*x3+x4*x5*x6+x7*x8*x9");
    }

    public void testAssign() throws ParseException, Exception {
        this.rpTest2(new String[]{"x=5", "x+x"});
        this.j.setVarValue("x", (Object)new Double(6.0));
        this.rpTest2(new String[]{"x+x"});
    }

    public void testLogical() throws ParseException, Exception {
        this.rpTest2(new String[]{"1&&1", "1&&0", "0&&0", "0&&1", "3.14&&1"});
        this.rpTest2(new String[]{"1||1", "1||0", "0||0", "0||1", "3.14||0"});
        this.rpTest2(new String[]{"!0", "!1", "!3.14", "!-3.14"});
        this.rpTest2(new String[]{"1>1", "1>0", "0>0", "0>1", "3.14>1"});
        this.rpTest2(new String[]{"1<1", "1<0", "0<0", "0<1", "3.14<1"});
        this.rpTest2(new String[]{"1>=1", "1>=0", "0>=0", "0>=1", "3.14>=1"});
        this.rpTest2(new String[]{"1<=1", "1<=0", "0<=0", "0<=1", "3.14<=1"});
        this.rpTest2(new String[]{"1==1", "1==0", "0==0", "0==1", "3.14==1"});
        this.rpTest2(new String[]{"1!=1", "1!=0", "0!=0", "0!=1", "3.14!=1"});
    }

    public void testFun() throws ParseException, Exception {
        this.rpTest2(new String[]{"x=5", "y=4", "x/y", "x%y", "x^y"});
        this.rpTest2(new String[]{"x=0.5", "cos(x)", "sin(x)", "tan(x)", "asin(x)", "acos(x)", "atan(x)"});
        this.rpTest2(new String[]{"x=0.5", "cosh(x)", "sinh(x)", "tanh(x)", "asinh(x)", "acosh(x+1)", "atanh(x)"});
        this.rpTest2(new String[]{"x=0.5", "sqrt(x)", "ln(x)", "log(x)", "exp(x)", "abs(x)"});
        this.rpTest2(new String[]{"x=0.5", "cos(x)^2+sin(x)^2"});
        this.rpTest2(new String[]{"x=0.5", "sec(x)", "cosec(x)", "cot(x)"});
        this.rpTest2(new String[]{"x=3", "y=4", "atan2(y,x)", "if(x>y,1,2)", "if(x<y,1,2)"});
    }
}

