/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.rpe.RpCommand;
import org.lsmp.djep.rpe.RpCommandList;
import org.lsmp.djep.rpe.RpEval;
import org.nfunk.jep.JEP;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

/*
 * Exception performing whole class analysis ignored.
 */
public class RpExample {
    static JEP j;

    public static void main(String[] args) {
        j = new JEP();
        j.addStandardConstants();
        j.addStandardFunctions();
        j.addComplex();
        j.setAllowUndeclared(true);
        j.setImplicitMul(true);
        j.setAllowAssignment(true);
        RpExample.doStuff((String)"1*2*3+4*5*6+7*8*9");
        RpExample.doAll((String[])new String[]{"x1=1", "x2=2", "x3=3", "x4=4", "x5=5", "x6=6", "x7=7", "x8=8", "x9=9", "x1*x2*x3+x4*x5*x6+x7*x8*x9"});
        RpExample.doAll((String[])new String[]{"x=0.7", "cos(x)^2+sin(x)^2"});
    }

    public static void extendedPrint(RpCommandList list) throws ParseException {
        int num = list.getNumCommands();
        int i = 0;
        while (i < num) {
            RpCommand com = list.getCommand(i);
            int type = com.getType();
            int ref = com.getRef();
            if (type == 0) {
                double val = com.getConstantValue();
                System.out.println("Constant\t" + val + "\t" + ref);
            } else if (type == 1) {
                Variable var = com.getVariable();
                System.out.println("Variable\t" + var.toString() + "\t" + ref);
            } else if (type == 23) {
                String name = com.getFunction();
                System.out.println("Function\t" + name + "\t" + ref);
            } else {
                System.out.println("Operator\t" + com.toString());
            }
            ++i;
        }
    }

    public static void doStuff(String str) {
        try {
            Node node = j.parse(str);
            RpEval rpe = new RpEval(j);
            RpCommandList list = rpe.compile(node);
            double res = rpe.evaluate(list);
            System.out.println("Expression:\t" + str + "\nresult\t" + res);
            System.out.println("Commands:");
            RpExample.extendedPrint((RpCommandList)list);
            System.out.println();
        }
        catch (ParseException e) {
            System.out.println("Parse error " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("evaluation error " + e.getMessage());
            e.printStackTrace();
        }
    }

    public static void doAll(String[] str) {
        try {
            RpEval rpe = new RpEval(j);
            int i = 0;
            while (i < str.length) {
                Node node = j.parse(str[i]);
                RpCommandList list = rpe.compile(node);
                double res = rpe.evaluate(list);
                System.out.println("Expression " + i + ":\t" + str[i] + "\nresult\t" + res);
                System.out.println("Commands:");
                RpExample.extendedPrint((RpCommandList)list);
                System.out.println();
                ++i;
            }
        }
        catch (ParseException e) {
            System.out.println("Parse error " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("evaluation error " + e.getMessage());
            e.printStackTrace();
        }
    }
}

