/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.vectorJep.VectorJep;
import org.nfunk.jep.Node;

/*
 * Exception performing whole class analysis ignored.
 */
public class MatrixSpeed {
    static MatrixJep mj;
    static VectorJep vj;
    static int num_itts;

    static {
        num_itts = 100000;
    }

    public static void main(String[] args) {
        long t1 = System.currentTimeMillis();
        MatrixSpeed.initVec();
        long t2 = System.currentTimeMillis();
        System.out.println("Vec initialise " + (t2 - t1));
        MatrixSpeed.initMat();
        long t3 = System.currentTimeMillis();
        System.out.println("Mat initialise " + (t3 - t2));
        MatrixSpeed.doBoth((String)"y=[[1,2,3],[3,4,5],[6,7,8]]", (String)"y*y");
        MatrixSpeed.doBoth((String)"y=[[1,2,3],[3,4,5],[6,7,8]]", (String)"y+y");
        MatrixSpeed.doBoth((String)"y=[[1,2,3],[3,4,5],[6,7,8]]", (String)"y-y");
        MatrixSpeed.doBoth((String)"y=[[1,2,3],[3,4,5],[6,7,8]]", (String)"y*y+y");
        MatrixSpeed.doBoth((String)"y=[1,2,3]", (String)"y+y");
        MatrixSpeed.doBoth((String)"y=[1,2,3]", (String)"y . y");
        MatrixSpeed.doBoth((String)"y=[1,2,3]", (String)"y^^y");
    }

    public static void doBoth(String eqn1, String eqn2) {
        System.out.println("Testing speed for <" + eqn1 + "> and <" + eqn2 + ">");
        MatrixSpeed.doVec((String)eqn1, (String)eqn2);
        MatrixSpeed.doMat((String)eqn1, (String)eqn2);
    }

    static void initVec() {
        vj = new VectorJep();
        vj.addStandardConstants();
        vj.addStandardFunctions();
        vj.addComplex();
        vj.setAllowUndeclared(true);
        vj.setImplicitMul(true);
        vj.setAllowAssignment(true);
    }

    static void doVec(String eqn1, String eqn2) {
        try {
            Node node1 = vj.parse(eqn1);
            vj.evaluate(node1);
            Node node = vj.parse(eqn2);
            long t1 = System.currentTimeMillis();
            int i = 0;
            while (i < num_itts) {
                vj.evaluate(node);
                ++i;
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Using VectorJep :" + (t2 - t1));
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
        }
    }

    static void initMat() {
        mj = new MatrixJep();
        mj.addStandardConstants();
        mj.addStandardFunctions();
        mj.addComplex();
        mj.setAllowUndeclared(true);
        mj.setImplicitMul(true);
        mj.setAllowAssignment(true);
    }

    static void doMat(String eqn1, String eqn2) {
        try {
            Node node2 = mj.simplify(mj.preprocess(mj.parse(eqn1)));
            mj.evaluate(node2);
            Node node3 = mj.simplify(mj.preprocess(mj.parse(eqn2)));
            long t1 = System.currentTimeMillis();
            int i = 0;
            while (i < num_itts) {
                mj.evaluateRaw(node3);
                ++i;
            }
            long t2 = System.currentTimeMillis();
            System.out.println("Using MatrixJep :" + (t2 - t1));
        }
        catch (Exception e) {
            System.out.println("Error" + e.getMessage());
        }
    }
}

