/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djepExamples.DJepConsole;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

public class MatrixConsole
extends DJepConsole {
    private static final long serialVersionUID = -4768856862892634425L;

    public static void main(String[] args) {
        MatrixConsole c = new MatrixConsole();
        c.run(args);
    }

    public String getPrompt() {
        return "MatrixJep > ";
    }

    public void initialise() {
        this.j = new MatrixJep();
        this.j.addStandardConstants();
        this.j.addStandardFunctions();
        this.j.addComplex();
        this.j.setAllowUndeclared(true);
        this.j.setImplicitMul(true);
        this.j.setAllowAssignment(true);
        ((MatrixJep)this.j).addStandardDiffRules();
    }

    public void printHelp() {
        super.printHelp();
        this.println((Object)"Dot product: [1,2,3].[4,5,6]");
        this.println((Object)"Cross product: [1,2,3]^[4,5,6]");
        this.println((Object)"Matrix Multiplication: [[1,2],[3,4]]*[[1,2],[3,4]]");
    }

    public void printIntroText() {
        this.println((Object)"MatrixJep: advanced vector and matrix handling");
        super.printStdHelp();
    }

    public void processEquation(Node node) throws ParseException {
        MatrixJep mj = (MatrixJep)this.j;
        if (this.verbose) {
            this.print((Object)"Parsed:\t\t");
            this.println((Object)mj.toString(node));
        }
        Node processed = mj.preprocess(node);
        if (this.verbose) {
            this.print((Object)"Processed:\t");
            this.println((Object)mj.toString(processed));
        }
        Node simp = mj.simplify(processed);
        if (this.verbose) {
            this.print((Object)"Simplified:\t");
            this.println((Object)mj.toString(simp));
        }
        Object val = mj.evaluate(simp);
        String s = mj.getPrintVisitor().formatValue(val);
        this.println((Object)("Value:\t\t" + s));
    }
}

