/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djepExamples;

import org.lsmp.djep.matrixJep.MatrixJep;
import org.lsmp.djep.mrpe.MRpCommandList;
import org.lsmp.djep.mrpe.MRpEval;
import org.lsmp.djep.mrpe.MRpRes;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.Node;
import org.nfunk.jep.ParseException;

/*
 * Exception performing whole class analysis ignored.
 */
public class MRpExample {
    static MatrixJep mj;
    static MRpEval rpe;

    public static void main(String[] args) {
        mj = new MatrixJep();
        mj.addStandardConstants();
        mj.addStandardFunctions();
        mj.addComplex();
        mj.setAllowUndeclared(true);
        mj.setImplicitMul(true);
        mj.setAllowAssignment(true);
        rpe = new MRpEval(mj);
        MRpExample.doStuff((String)"[1,2,3]");
        MRpExample.doStuff((String)"[1,2,3].[4,5,6]");
        MRpExample.doStuff((String)"[1,2,3]^[4,5,6]");
        MRpExample.doStuff((String)"[1,2,3]+[4,5,6]");
        MRpExample.doStuff((String)"[[1,2],[3,4]]");
        MRpExample.doStuff((String)"[[1,2],[3,4]]*[1,0]");
        MRpExample.doStuff((String)"[1,0]*[[1,2],[3,4]]");
        MRpExample.doStuff((String)"[[1,2],[3,4]]*[[1,2],[3,4]]");
        MRpExample.doStuff((String)"x=[1,2,3]");
        MRpExample.doStuff((String)"x+x");
        MRpExample.doStuff((String)"x . x");
        MRpExample.doStuff((String)"x^x");
        MRpExample.doStuff((String)"y=[[1,2],[3,4]]");
        MRpExample.doStuff((String)"y * y");
    }

    public static void doStuff(String str) {
        try {
            Node node = mj.parse(str);
            Node proc = mj.preprocess(node);
            Node simp = mj.simplify(proc);
            MRpCommandList list = rpe.compile(simp);
            MRpRes res = rpe.evaluate(list);
            mj.print(node);
            System.out.println("\nres " + res.toString());
            MatrixValueI mat = res.toVecMat();
            System.out.println("matrix " + mat.toString());
            if (res.getDims().is1D()) {
                double[] vecArray = (double[])res.toArray();
                System.out.print("[");
                int i = 0;
                while (i < vecArray.length) {
                    System.out.print(vecArray[i] + " ");
                    ++i;
                }
                System.out.println("]");
            } else if (res.getDims().is2D()) {
                double[][] matArray = (double[][])res.toArray();
                System.out.print("[");
                int i = 0;
                while (i < matArray.length) {
                    System.out.print("[");
                    int j = 0;
                    while (j < matArray[i].length) {
                        System.out.print(matArray[i][j] + " ");
                        ++j;
                    }
                    System.out.print("]");
                    ++i;
                }
                System.out.println("]");
            }
            System.out.println("Commands");
            System.out.println(list.toString());
        }
        catch (ParseException e) {
            System.out.println("Parse error " + e.getMessage());
        }
        catch (Exception e) {
            System.out.println("evaluation error " + e.getMessage());
            e.printStackTrace();
        }
    }
}

