/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.Add;
import org.nfunk.jep.function.Multiply;
import org.nfunk.jep.function.Subtract;

public class MMultiply
extends Multiply
implements BinaryOperatorI {
    protected Add add = new Add();
    protected Subtract sub = new Subtract();

    public MMultiply() {
        this.numberOfParameters = 2;
    }

    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param2 = stack.pop();
        Object param1 = stack.pop();
        Object product = this.mul(param1, param2);
        stack.push(product);
    }

    public Object mul(Object param1, Object param2) throws ParseException {
        if (param1 instanceof MatrixValueI && param2 instanceof MatrixValueI) {
            return this.mul((MatrixValueI)param1, (MatrixValueI)param2);
        }
        if (param1 instanceof MatrixValueI) {
            MatrixValueI l = (MatrixValueI)param1;
            MatrixValueI res = Tensor.getInstance((Dimensions)l.getDim());
            int i = 0;
            while (i < res.getNumEles()) {
                res.setEle(i, super.mul(l.getEle(i), param2));
                ++i;
            }
            return res;
        }
        if (param2 instanceof MatrixValueI) {
            MatrixValueI r = (MatrixValueI)param2;
            MatrixValueI res = Tensor.getInstance((Dimensions)r.getDim());
            int i = 0;
            while (i < res.getNumEles()) {
                res.setEle(i, super.mul(param1, r.getEle(i)));
                ++i;
            }
            return res;
        }
        return super.mul(param1, param2);
    }

    public Object mul(MatrixValueI param1, MatrixValueI param2) throws ParseException {
        Dimensions dims = this.calcDim(param1.getDim(), param2.getDim());
        MatrixValueI res = Tensor.getInstance((Dimensions)dims);
        return this.calcValue(res, param1, param2);
    }

    public Dimensions calcDim(Dimensions l, Dimensions r) throws ParseException {
        int lrank = l.rank();
        int rrank = r.rank();
        block0 : switch (lrank) {
            case 0: {
                return r;
            }
            case 1: {
                switch (rrank) {
                    case 0: {
                        return l;
                    }
                    case 1: {
                        return Dimensions.valueOf((int)l.getFirstDim(), (int)r.getFirstDim());
                    }
                    case 2: {
                        if (l.getLastDim() != r.getFirstDim()) break block0;
                        return Dimensions.valueOf((int)r.getLastDim());
                    }
                    default: {
                        throw new ParseException("Sorry I don't know how to multiply a vector by a tensor");
                    }
                }
            }
            case 2: {
                switch (rrank) {
                    case 0: {
                        return l;
                    }
                    case 1: {
                        if (l.getLastDim() != r.getFirstDim()) break block0;
                        return Dimensions.valueOf((int)l.getFirstDim());
                    }
                    case 2: {
                        if (l.getLastDim() != r.getFirstDim()) break block0;
                        return Dimensions.valueOf((int)l.getFirstDim(), (int)r.getLastDim());
                    }
                }
                break;
            }
            default: {
                switch (rrank) {
                    case 0: {
                        return l;
                    }
                }
            }
        }
        throw new ParseException("Dimensions for multiply do not match: " + l + " " + r);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI param1, MatrixValueI param2) throws ParseException {
        if (param1 instanceof Scaler) {
            if (param2 instanceof Scaler) {
                res.setEle(0, super.mul(param1.getEle(0), param2.getEle(0)));
                return res;
            } else if (param2 instanceof MVector) {
                int i = 0;
                while (i < param2.getDim().getFirstDim()) {
                    res.setEle(i, super.mul(param1.getEle(0), param2.getEle(i)));
                    ++i;
                }
                return res;
            } else if (param2 instanceof Matrix) {
                Matrix r = (Matrix)param2;
                Matrix mres = (Matrix)res;
                int i = 0;
                while (i < r.getNumRows()) {
                    int j = 0;
                    while (j < r.getNumCols()) {
                        mres.setEle(i, j, super.mul(param1.getEle(0), r.getEle(i, j)));
                        ++j;
                    }
                    ++i;
                }
                return res;
            } else {
                int i = 0;
                while (i < param2.getDim().numEles()) {
                    res.setEle(i, super.mul(param1.getEle(0), param2.getEle(i)));
                    ++i;
                }
            }
            return res;
        } else if (param1 instanceof MVector) {
            if (param2 instanceof Scaler) {
                int i = 0;
                while (i < param1.getDim().getFirstDim()) {
                    res.setEle(i, super.mul(param1.getEle(i), param2.getEle(0)));
                    ++i;
                }
                return res;
            } else if (param2 instanceof MVector) {
                Matrix mat = (Matrix)res;
                int i = 0;
                while (i < param1.getDim().getFirstDim()) {
                    int j = 0;
                    while (j < param2.getDim().getFirstDim()) {
                        mat.setEle(i, j, super.mul(param1.getEle(i), param2.getEle(j)));
                        ++j;
                    }
                    ++i;
                }
                return res;
            } else {
                if (!(param2 instanceof Matrix)) throw new ParseException("Sorry I don't know how to multiply a vector by a tensor");
                MVector lhs = (MVector)param1;
                Matrix rhs = (Matrix)param2;
                if (lhs.getNumEles() != rhs.getNumRows()) {
                    throw new ParseException("Multiply Matrix , Vector: Miss match in sizes (" + lhs.getNumEles() + "," + rhs.getNumRows() + ")!");
                }
                int i = 0;
                while (i < rhs.getNumCols()) {
                    Object val = super.mul(lhs.getEle(0), rhs.getEle(0, i));
                    int j = 1;
                    while (j < rhs.getNumRows()) {
                        val = this.add.add(val, super.mul(lhs.getEle(j), rhs.getEle(j, i)));
                        ++j;
                    }
                    res.setEle(i, val);
                    ++i;
                }
            }
            return res;
        } else if (param1 instanceof Matrix) {
            if (param2 instanceof Scaler) {
                Matrix l = (Matrix)param1;
                Matrix mres = (Matrix)res;
                int i = 0;
                while (i < l.getNumRows()) {
                    int j = 0;
                    while (j < l.getNumCols()) {
                        mres.setEle(i, j, super.mul(l.getEle(i, j), param2.getEle(0)));
                        ++j;
                    }
                    ++i;
                }
                return res;
            } else if (param2 instanceof MVector) {
                Matrix lhs = (Matrix)param1;
                MVector rhs = (MVector)param2;
                if (lhs.getNumCols() != rhs.getNumEles()) {
                    throw new ParseException("Mat * Vec: Miss match in sizes (" + lhs.getNumCols() + "," + rhs.getNumEles() + ") when trying to add vectors!");
                }
                int i = 0;
                while (i < lhs.getNumRows()) {
                    Object val = super.mul(lhs.getEle(i, 0), rhs.getEle(0));
                    int j = 1;
                    while (j < lhs.getNumCols()) {
                        val = this.add.add(val, super.mul(lhs.getEle(i, j), rhs.getEle(j)));
                        ++j;
                    }
                    res.setEle(i, val);
                    ++i;
                }
                return res;
            } else {
                if (!(param2 instanceof Matrix)) throw new ParseException("Sorry I don't know how to multiply a matrix by a tensor");
                Matrix lhs = (Matrix)param1;
                Matrix rhs = (Matrix)param2;
                Matrix mres = (Matrix)res;
                if (lhs.getNumCols() != rhs.getNumRows()) {
                    throw new ParseException("Multiply matrix,matrix: Miss match in number of dims (" + lhs.getNumCols() + "," + rhs.getNumRows() + ")!");
                }
                int lnr = lhs.getNumRows();
                int lnc = lhs.getNumCols();
                int rnc = rhs.getNumCols();
                Object[][] ldata = lhs.getEles();
                Object[][] rdata = rhs.getEles();
                Object[][] resdata = mres.getEles();
                int i = 0;
                while (i < lnr) {
                    int j = 0;
                    while (j < rnc) {
                        Object val = this.mul(ldata[i][0], rdata[0][j]);
                        int k = 1;
                        while (k < lnc) {
                            val = this.add.add(val, this.mul(ldata[i][k], rdata[k][j]));
                            ++k;
                        }
                        resdata[i][j] = val;
                        ++j;
                    }
                    ++i;
                }
            }
            return res;
        } else {
            if (!(param2 instanceof Scaler)) throw new ParseException("Sorry I don't know how to multiply a tensor by a vector");
            int i = 0;
            while (i < param1.getDim().numEles()) {
                res.setEle(i, super.mul(param1.getEle(i), param2.getEle(0)));
                ++i;
            }
        }
        return res;
    }
}

