/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.rpe;

import org.lsmp.djep.rpe.RpEval;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.Variable;

public final class RpCommand {
    short command;
    short aux1;
    RpEval rpe;

    private RpCommand() {
    }

    RpCommand(RpEval rpe, short command) {
        this.command = command;
        this.aux1 = (short)-1;
        this.rpe = rpe;
    }

    RpCommand(RpEval rpe, short command, short aux) {
        this.command = command;
        this.aux1 = aux;
        this.rpe = rpe;
    }

    public String toString() {
        switch (this.command) {
            case 0: {
                return "Constant\tno " + this.aux1;
            }
            case 1: {
                return "Variable\tnum " + this.aux1;
            }
            case 2: {
                return "ADD";
            }
            case 3: {
                return "SUB";
            }
            case 4: {
                return "MUL";
            }
            case 5: {
                return "DIV";
            }
            case 6: {
                return "MOD";
            }
            case 7: {
                return "POW";
            }
            case 8: {
                return "AND";
            }
            case 9: {
                return "OR";
            }
            case 10: {
                return "NOT";
            }
            case 11: {
                return "LT";
            }
            case 12: {
                return "LE";
            }
            case 13: {
                return "GT";
            }
            case 14: {
                return "GE";
            }
            case 16: {
                return "EQ";
            }
            case 15: {
                return "NE";
            }
            case 20: {
                return "Assign\tnum " + this.aux1;
            }
            case 23: {
                return "Function\tnum " + this.aux1;
            }
        }
        return "WARNING unknown command: " + this.command + " " + this.aux1;
    }

    public int getType() {
        return this.command;
    }

    public int getRef() {
        return this.aux1;
    }

    public double getConstantValue() throws ParseException {
        if (this.command != 0) {
            throw new ParseException("This element is not a constant.");
        }
        return this.rpe.constVals[this.aux1];
    }

    public Variable getVariable() throws ParseException {
        if (this.command != 1) {
            throw new ParseException("This element is not a variable.");
        }
        return this.rpe.getVariable((int)this.aux1);
    }

    public String getFunction() throws ParseException {
        if (this.command != 23) {
            throw new ParseException("This element is not a function.");
        }
        return this.rpe.getFunction(this.aux1);
    }
}

