/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.jama;

import Jama.Matrix;
import java.util.Stack;
import org.lsmp.djep.jama.JamaUtil;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class Solve
extends PostfixMathCommand
implements BinaryOperatorI {
    public Solve() {
        this.numberOfParameters = 2;
    }

    public void run(Stack s) throws ParseException {
        Object r = s.pop();
        if (!(r instanceof org.lsmp.djep.vectorJep.values.Matrix)) {
            throw new ParseException("solve: can only be applied to a matrix");
        }
        Object l = s.pop();
        if (!(l instanceof org.lsmp.djep.vectorJep.values.Matrix)) {
            throw new ParseException("solve: can only be applied to a matrix");
        }
        Matrix m = JamaUtil.toJama((org.lsmp.djep.vectorJep.values.Matrix)((org.lsmp.djep.vectorJep.values.Matrix)l));
        Matrix b = JamaUtil.toJama((org.lsmp.djep.vectorJep.values.Matrix)((org.lsmp.djep.vectorJep.values.Matrix)r));
        Matrix solve = m.solve(b);
        org.lsmp.djep.vectorJep.values.Matrix res = JamaUtil.fromJama((Matrix)solve);
        s.push(res);
    }

    public Dimensions calcDim(Dimensions ldim, Dimensions rdim) {
        int rows = ldim.getLastDim();
        int cols = rdim.getLastDim();
        return Dimensions.valueOf((int)rows, (int)cols);
    }

    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI lhs, MatrixValueI rhs) throws ParseException {
        if (!(lhs instanceof org.lsmp.djep.vectorJep.values.Matrix)) {
            throw new ParseException("solve: can only be applied to a matrix");
        }
        if (!(res instanceof org.lsmp.djep.vectorJep.values.Matrix)) {
            throw new ParseException("inverse: result should be a matrix");
        }
        Matrix m = JamaUtil.toJama((org.lsmp.djep.vectorJep.values.Matrix)((org.lsmp.djep.vectorJep.values.Matrix)lhs));
        Matrix b = JamaUtil.toJama((org.lsmp.djep.vectorJep.values.Matrix)((org.lsmp.djep.vectorJep.values.Matrix)rhs));
        Matrix solve = m.solve(b);
        JamaUtil.fromJama((Matrix)solve, (org.lsmp.djep.vectorJep.values.Matrix)((org.lsmp.djep.vectorJep.values.Matrix)res));
        return res;
    }
}

