/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.values;

import java.math.BigInteger;

public class Rational
extends Number
implements Comparable {
    private BigInteger numerator;
    private BigInteger denominator;

    private Rational() {
    }

    public Rational(BigInteger num) {
        this.numerator = num;
        this.denominator = BigInteger.ONE;
    }

    public Rational(BigInteger num, BigInteger den) {
        BigInteger gcd = num.gcd(den);
        if (gcd.equals(BigInteger.ZERO)) {
            this.numerator = this.denominator = BigInteger.ZERO;
        } else if (den.signum() > 0) {
            this.numerator = num.divide(gcd);
            this.denominator = den.divide(gcd);
        } else {
            this.numerator = num.divide(gcd).negate();
            this.denominator = den.divide(gcd).negate();
        }
    }

    public int intValue() {
        if (this.denominator.equals(BigInteger.ZERO)) {
            int sign = this.numerator.signum();
            if (sign == 0) {
                return Integer.MAX_VALUE;
            }
            if (sign > 0) {
                return Integer.MAX_VALUE;
            }
            return Integer.MIN_VALUE;
        }
        return this.numerator.divide(this.denominator).intValue();
    }

    public long longValue() {
        return this.numerator.divide(this.denominator).longValue();
    }

    public float floatValue() {
        if (this.denominator.equals(BigInteger.ZERO)) {
            int sign = this.numerator.signum();
            if (sign == 0) {
                return Float.NaN;
            }
            if (sign > 0) {
                return Float.POSITIVE_INFINITY;
            }
            return Float.NEGATIVE_INFINITY;
        }
        return this.numerator.divide(this.denominator).floatValue();
    }

    public double doubleValue() {
        if (this.denominator.equals(BigInteger.ZERO)) {
            int sign = this.numerator.signum();
            if (sign == 0) {
                return Double.NaN;
            }
            if (sign > 0) {
                return Double.POSITIVE_INFINITY;
            }
            return Double.NEGATIVE_INFINITY;
        }
        return this.numerator.divide(this.denominator).doubleValue();
    }

    public Rational add(Rational arg) {
        BigInteger ad = this.numerator.multiply(arg.denominator);
        BigInteger bc = this.denominator.multiply(arg.numerator);
        BigInteger bd = this.denominator.multiply(arg.denominator);
        BigInteger top = ad.add(bc);
        return new Rational(top, bd);
    }

    public Rational sub(Rational arg) {
        BigInteger ad = this.numerator.multiply(arg.denominator);
        BigInteger bc = this.denominator.multiply(arg.numerator);
        BigInteger bd = this.denominator.multiply(arg.denominator);
        BigInteger top = ad.subtract(bc);
        return new Rational(top, bd);
    }

    public Rational mul(Rational arg) {
        BigInteger ac = this.numerator.multiply(arg.numerator);
        BigInteger bd = this.denominator.multiply(arg.denominator);
        return new Rational(ac, bd);
    }

    public Rational div(Rational arg) {
        BigInteger ad = this.numerator.multiply(arg.denominator);
        BigInteger bc = this.denominator.multiply(arg.numerator);
        return new Rational(ad, bc);
    }

    public Rational pow(Rational arg) {
        if (!arg.denominator.equals(BigInteger.ONE)) {
            throw new ArithmeticException("Can only raise rationals to integer powers");
        }
        int exponant = arg.numerator.intValue();
        if (exponant == 0) {
            return new Rational(BigInteger.ONE);
        }
        if (exponant > 0) {
            BigInteger top = this.numerator.pow(exponant);
            BigInteger bot = this.denominator.pow(exponant);
            return new Rational(top, bot);
        }
        BigInteger top = this.numerator.pow(-exponant);
        BigInteger bot = this.denominator.pow(-exponant);
        return new Rational(bot, top);
    }

    public Rational negate() {
        return new Rational(this.numerator.negate(), this.denominator);
    }

    public Rational inverse() {
        return new Rational(this.denominator, this.numerator);
    }

    public static Number valueOf(String s) {
        int pos = s.indexOf(47);
        if (pos == -1) {
            return new Rational(new BigInteger(s));
        }
        return new Rational(new BigInteger(s.substring(pos - 1)), new BigInteger(s.substring(pos + 1, -1)));
    }

    public BigInteger getDenominator() {
        return this.denominator;
    }

    public BigInteger getNumerator() {
        return this.numerator;
    }

    public String toString() {
        if (this.denominator.equals(BigInteger.ONE)) {
            return this.numerator.toString();
        }
        return String.valueOf(this.numerator.toString()) + "/" + this.denominator.toString();
    }

    public int compareTo(Object arg) {
        Rational num = (Rational)arg;
        if (this.denominator.compareTo(num.denominator) == 0) {
            return this.numerator.compareTo(num.numerator);
        }
        BigInteger ad = this.numerator.multiply(num.denominator);
        BigInteger bc = this.denominator.multiply(num.numerator);
        return ad.compareTo(bc);
    }
}

