/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.groupJep.groups;

import org.lsmp.djep.groupJep.groups.Group;
import org.lsmp.djep.groupJep.groups.Quaternions;
import org.lsmp.djep.groupJep.interfaces.RingI;
import org.nfunk.jep.JEP;

public class Quaternions
extends Group
implements RingI {
    private Quaternion ZERO = new Quaternion(0.0, 0.0, 0.0, 0.0);
    private Quaternion ONE = new Quaternion(1.0, 0.0, 0.0, 0.0);
    private Quaternion I = new Quaternion(0.0, 1.0, 0.0, 0.0);
    private Quaternion J = new Quaternion(0.0, 0.0, 1.0, 0.0);
    private Quaternion K = new Quaternion(0.0, 0.0, 0.0, 1.0);

    public Number getZERO() {
        return this.ZERO;
    }

    public Number getONE() {
        return this.ONE;
    }

    public Number getInverse(Number num) {
        Quaternion q = (Quaternion)num;
        return new Quaternion(-q.x, -q.y, -q.z, -q.w);
    }

    public Number add(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return new Quaternion(p.x + q.x, p.y + q.y, p.z + q.z, p.w + q.w);
    }

    public Number sub(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return new Quaternion(p.x - q.x, p.y - q.y, p.z - q.z, p.w - q.w);
    }

    public Number mul(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return new Quaternion(p.x * q.x - p.y * q.y - p.z * q.z - p.w * q.w, p.x * q.y - p.y * q.x + p.z * q.w - p.w * q.z, p.x * q.z - p.y * q.w + p.z * q.x + p.w * q.y, p.x * q.w - p.y * q.z - p.z * q.y + p.w * q.x);
    }

    public boolean equals(Number a, Number b) {
        Quaternion p = (Quaternion)a;
        Quaternion q = (Quaternion)b;
        return p.x == q.x && p.y == q.y && p.z == q.z && p.w == q.w;
    }

    public Number valueOf(String s) {
        return new Quaternion(Double.parseDouble(s), 0.0, 0.0, 0.0);
    }

    public void addStandardConstants(JEP j) {
        super.addStandardConstants(j);
        j.addConstant("i", (Object)this.I);
        j.addConstant("j", (Object)this.J);
        j.addConstant("k", (Object)this.K);
    }

    public String toString() {
        return "Quaternions";
    }
}

