/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.regression;

import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.QRDecomposition;
import org.apache.commons.math.linear.QRDecompositionImpl;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.stat.regression.AbstractMultipleLinearRegression;

public class OLSMultipleLinearRegression
extends AbstractMultipleLinearRegression {
    private QRDecomposition qr = null;

    public void newSampleData(double[] y, double[][] x) {
        this.validateSampleData(x, y);
        this.newYSampleData(y);
        this.newXSampleData(x);
    }

    public void newSampleData(double[] data, int nobs, int nvars) {
        super.newSampleData(data, nobs, nvars);
        this.qr = new QRDecompositionImpl(this.X);
    }

    public RealMatrix calculateHat() {
        RealMatrix Q = this.qr.getQ();
        int p = this.qr.getR().getColumnDimension();
        int n = Q.getColumnDimension();
        Array2DRowRealMatrix augI = new Array2DRowRealMatrix(n, n);
        double[][] augIData = augI.getDataRef();
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                augIData[i][j] = i == j && i < p ? 1.0 : 0.0;
            }
        }
        return Q.multiply((RealMatrix)augI).multiply(Q.transpose());
    }

    protected void newXSampleData(double[][] x) {
        this.X = new Array2DRowRealMatrix(x);
        this.qr = new QRDecompositionImpl(this.X);
    }

    protected RealVector calculateBeta() {
        return this.qr.getSolver().solve(this.Y);
    }

    protected RealMatrix calculateBetaVariance() {
        int p = this.X.getColumnDimension();
        RealMatrix Raug = this.qr.getR().getSubMatrix(0, p - 1, 0, p - 1);
        RealMatrix Rinv = new LUDecompositionImpl(Raug).getSolver().getInverse();
        return Rinv.multiply(Rinv.transpose());
    }

    protected double calculateYVariance() {
        RealVector residuals = this.calculateResiduals();
        return residuals.dotProduct(residuals) / (double)(this.X.getRowDimension() - this.X.getColumnDimension());
    }
}

