/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.inference;

import java.util.Collection;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.distribution.FDistributionImpl;
import org.apache.commons.math.stat.descriptive.summary.Sum;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;
import org.apache.commons.math.stat.inference.OneWayAnova;
import org.apache.commons.math.stat.inference.OneWayAnovaImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class OneWayAnovaImpl
implements OneWayAnova {
    public double anovaFValue(Collection<double[]> categoryData) throws IllegalArgumentException, MathException {
        AnovaStats a = this.anovaStats(categoryData);
        return AnovaStats.access$000((AnovaStats)a);
    }

    public double anovaPValue(Collection<double[]> categoryData) throws IllegalArgumentException, MathException {
        AnovaStats a = this.anovaStats(categoryData);
        FDistributionImpl fdist = new FDistributionImpl((double)AnovaStats.access$100((AnovaStats)a), (double)AnovaStats.access$200((AnovaStats)a));
        return 1.0 - fdist.cumulativeProbability(AnovaStats.access$000((AnovaStats)a));
    }

    public boolean anovaTest(Collection<double[]> categoryData, double alpha) throws IllegalArgumentException, MathException {
        if (alpha <= 0.0 || alpha > 0.5) {
            throw MathRuntimeException.createIllegalArgumentException((String)"out of bounds significance level {0}, must be between {1} and {2}", (Object[])new Object[]{alpha, 0, 0.5});
        }
        return this.anovaPValue(categoryData) < alpha;
    }

    private AnovaStats anovaStats(Collection<double[]> categoryData) throws IllegalArgumentException, MathException {
        if (categoryData.size() < 2) {
            throw MathRuntimeException.createIllegalArgumentException((String)"two or more categories required, got {0}", (Object[])new Object[]{categoryData.size()});
        }
        for (double[] array : categoryData) {
            if (array.length > 1) continue;
            throw MathRuntimeException.createIllegalArgumentException((String)"two or more values required in each category, one has {0}", (Object[])new Object[]{array.length});
        }
        int dfwg = 0;
        double sswg = 0.0;
        Sum totsum = new Sum();
        SumOfSquares totsumsq = new SumOfSquares();
        int totnum = 0;
        for (double[] data : categoryData) {
            Sum sum = new Sum();
            SumOfSquares sumsq = new SumOfSquares();
            int num = 0;
            for (int i = 0; i < data.length; ++i) {
                double val = data[i];
                ++num;
                sum.increment(val);
                sumsq.increment(val);
                ++totnum;
                totsum.increment(val);
                totsumsq.increment(val);
            }
            dfwg += num - 1;
            double ss = sumsq.getResult() - sum.getResult() * sum.getResult() / (double)num;
            sswg += ss;
        }
        double sst = totsumsq.getResult() - totsum.getResult() * totsum.getResult() / (double)totnum;
        double ssbg = sst - sswg;
        int dfbg = categoryData.size() - 1;
        double msbg = ssbg / (double)dfbg;
        double mswg = sswg / (double)dfwg;
        double F = msbg / mswg;
        return new AnovaStats(dfbg, dfwg, F, null);
    }
}

