/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive.rank;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.AbstractStorelessUnivariateStatistic;

/*
 * Exception performing whole class analysis ignored.
 */
public class Min
extends AbstractStorelessUnivariateStatistic
implements Serializable {
    private static final long serialVersionUID = -2941995784909003131L;
    private long n;
    private double value;

    public Min() {
        this.n = 0L;
        this.value = Double.NaN;
    }

    public Min(Min original) {
        Min.copy((Min)original, (Min)this);
    }

    public void increment(double d) {
        if (d < this.value || Double.isNaN(this.value)) {
            this.value = d;
        }
        ++this.n;
    }

    public void clear() {
        this.value = Double.NaN;
        this.n = 0L;
    }

    public double getResult() {
        return this.value;
    }

    public long getN() {
        return this.n;
    }

    public double evaluate(double[] values, int begin, int length) {
        double min = Double.NaN;
        if (this.test(values, begin, length)) {
            min = values[begin];
            for (int i = begin; i < begin + length; ++i) {
                if (Double.isNaN(values[i])) continue;
                min = min < values[i] ? min : values[i];
            }
        }
        return min;
    }

    public Min copy() {
        Min result = new Min();
        Min.copy((Min)this, (Min)result);
        return result;
    }

    public static void copy(Min source, Min dest) {
        dest.n = source.n;
        dest.value = source.value;
    }
}

