/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.stat.descriptive.StatisticalSummaryValues;
import org.apache.commons.math.stat.descriptive.StorelessUnivariateStatistic;
import org.apache.commons.math.stat.descriptive.moment.FirstMoment;
import org.apache.commons.math.stat.descriptive.moment.GeometricMean;
import org.apache.commons.math.stat.descriptive.moment.Mean;
import org.apache.commons.math.stat.descriptive.moment.SecondMoment;
import org.apache.commons.math.stat.descriptive.moment.Variance;
import org.apache.commons.math.stat.descriptive.rank.Max;
import org.apache.commons.math.stat.descriptive.rank.Min;
import org.apache.commons.math.stat.descriptive.summary.Sum;
import org.apache.commons.math.stat.descriptive.summary.SumOfLogs;
import org.apache.commons.math.stat.descriptive.summary.SumOfSquares;
import org.apache.commons.math.util.MathUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SummaryStatistics
implements StatisticalSummary,
Serializable {
    private static final long serialVersionUID = -2021321786743555871L;
    protected long n = 0L;
    protected SecondMoment secondMoment = new SecondMoment();
    protected Sum sum = new Sum();
    protected SumOfSquares sumsq = new SumOfSquares();
    protected Min min = new Min();
    protected Max max = new Max();
    protected SumOfLogs sumLog = new SumOfLogs();
    protected GeometricMean geoMean = new GeometricMean(this.sumLog);
    protected Mean mean = new Mean();
    protected Variance variance = new Variance();
    private StorelessUnivariateStatistic sumImpl = this.sum;
    private StorelessUnivariateStatistic sumsqImpl = this.sumsq;
    private StorelessUnivariateStatistic minImpl = this.min;
    private StorelessUnivariateStatistic maxImpl = this.max;
    private StorelessUnivariateStatistic sumLogImpl = this.sumLog;
    private StorelessUnivariateStatistic geoMeanImpl = this.geoMean;
    private StorelessUnivariateStatistic meanImpl = this.mean;
    private StorelessUnivariateStatistic varianceImpl = this.variance;

    public SummaryStatistics() {
    }

    public SummaryStatistics(SummaryStatistics original) {
        SummaryStatistics.copy((SummaryStatistics)original, (SummaryStatistics)this);
    }

    public StatisticalSummary getSummary() {
        return new StatisticalSummaryValues(this.getMean(), this.getVariance(), this.getN(), this.getMax(), this.getMin(), this.getSum());
    }

    public void addValue(double value) {
        this.sumImpl.increment(value);
        this.sumsqImpl.increment(value);
        this.minImpl.increment(value);
        this.maxImpl.increment(value);
        this.sumLogImpl.increment(value);
        this.secondMoment.increment(value);
        if (!(this.meanImpl instanceof Mean)) {
            this.meanImpl.increment(value);
        }
        if (!(this.varianceImpl instanceof Variance)) {
            this.varianceImpl.increment(value);
        }
        if (!(this.geoMeanImpl instanceof GeometricMean)) {
            this.geoMeanImpl.increment(value);
        }
        ++this.n;
    }

    public long getN() {
        return this.n;
    }

    public double getSum() {
        return this.sumImpl.getResult();
    }

    public double getSumsq() {
        return this.sumsqImpl.getResult();
    }

    public double getMean() {
        if (this.mean == this.meanImpl) {
            return new Mean((FirstMoment)this.secondMoment).getResult();
        }
        return this.meanImpl.getResult();
    }

    public double getStandardDeviation() {
        double stdDev = Double.NaN;
        if (this.getN() > 0L) {
            stdDev = this.getN() > 1L ? Math.sqrt(this.getVariance()) : 0.0;
        }
        return stdDev;
    }

    public double getVariance() {
        if (this.varianceImpl == this.variance) {
            return new Variance(this.secondMoment).getResult();
        }
        return this.varianceImpl.getResult();
    }

    public double getMax() {
        return this.maxImpl.getResult();
    }

    public double getMin() {
        return this.minImpl.getResult();
    }

    public double getGeometricMean() {
        return this.geoMeanImpl.getResult();
    }

    public double getSumOfLogs() {
        return this.sumLogImpl.getResult();
    }

    public double getSecondMoment() {
        return this.secondMoment.getResult();
    }

    public String toString() {
        StringBuffer outBuffer = new StringBuffer();
        String endl = "\n";
        outBuffer.append("SummaryStatistics:").append(endl);
        outBuffer.append("n: ").append(this.getN()).append(endl);
        outBuffer.append("min: ").append(this.getMin()).append(endl);
        outBuffer.append("max: ").append(this.getMax()).append(endl);
        outBuffer.append("mean: ").append(this.getMean()).append(endl);
        outBuffer.append("geometric mean: ").append(this.getGeometricMean()).append(endl);
        outBuffer.append("variance: ").append(this.getVariance()).append(endl);
        outBuffer.append("sum of squares: ").append(this.getSumsq()).append(endl);
        outBuffer.append("standard deviation: ").append(this.getStandardDeviation()).append(endl);
        outBuffer.append("sum of logs: ").append(this.getSumOfLogs()).append(endl);
        return outBuffer.toString();
    }

    public void clear() {
        this.n = 0L;
        this.minImpl.clear();
        this.maxImpl.clear();
        this.sumImpl.clear();
        this.sumLogImpl.clear();
        this.sumsqImpl.clear();
        this.geoMeanImpl.clear();
        this.secondMoment.clear();
        if (this.meanImpl != this.mean) {
            this.meanImpl.clear();
        }
        if (this.varianceImpl != this.variance) {
            this.varianceImpl.clear();
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof SummaryStatistics)) {
            return false;
        }
        SummaryStatistics stat = (SummaryStatistics)object;
        return MathUtils.equals((double)stat.getGeometricMean(), (double)this.getGeometricMean()) && MathUtils.equals((double)stat.getMax(), (double)this.getMax()) && MathUtils.equals((double)stat.getMean(), (double)this.getMean()) && MathUtils.equals((double)stat.getMin(), (double)this.getMin()) && MathUtils.equals((double)stat.getN(), (double)this.getN()) && MathUtils.equals((double)stat.getSum(), (double)this.getSum()) && MathUtils.equals((double)stat.getSumsq(), (double)this.getSumsq()) && MathUtils.equals((double)stat.getVariance(), (double)this.getVariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash((double)this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double)this.getGeometricMean());
        result = result * 31 + MathUtils.hash((double)this.getMax());
        result = result * 31 + MathUtils.hash((double)this.getMean());
        result = result * 31 + MathUtils.hash((double)this.getMin());
        result = result * 31 + MathUtils.hash((double)this.getN());
        result = result * 31 + MathUtils.hash((double)this.getSum());
        result = result * 31 + MathUtils.hash((double)this.getSumsq());
        result = result * 31 + MathUtils.hash((double)this.getVariance());
        return result;
    }

    public StorelessUnivariateStatistic getSumImpl() {
        return this.sumImpl;
    }

    public void setSumImpl(StorelessUnivariateStatistic sumImpl) {
        this.checkEmpty();
        this.sumImpl = sumImpl;
    }

    public StorelessUnivariateStatistic getSumsqImpl() {
        return this.sumsqImpl;
    }

    public void setSumsqImpl(StorelessUnivariateStatistic sumsqImpl) {
        this.checkEmpty();
        this.sumsqImpl = sumsqImpl;
    }

    public StorelessUnivariateStatistic getMinImpl() {
        return this.minImpl;
    }

    public void setMinImpl(StorelessUnivariateStatistic minImpl) {
        this.checkEmpty();
        this.minImpl = minImpl;
    }

    public StorelessUnivariateStatistic getMaxImpl() {
        return this.maxImpl;
    }

    public void setMaxImpl(StorelessUnivariateStatistic maxImpl) {
        this.checkEmpty();
        this.maxImpl = maxImpl;
    }

    public StorelessUnivariateStatistic getSumLogImpl() {
        return this.sumLogImpl;
    }

    public void setSumLogImpl(StorelessUnivariateStatistic sumLogImpl) {
        this.checkEmpty();
        this.sumLogImpl = sumLogImpl;
        this.geoMean.setSumLogImpl(sumLogImpl);
    }

    public StorelessUnivariateStatistic getGeoMeanImpl() {
        return this.geoMeanImpl;
    }

    public void setGeoMeanImpl(StorelessUnivariateStatistic geoMeanImpl) {
        this.checkEmpty();
        this.geoMeanImpl = geoMeanImpl;
    }

    public StorelessUnivariateStatistic getMeanImpl() {
        return this.meanImpl;
    }

    public void setMeanImpl(StorelessUnivariateStatistic meanImpl) {
        this.checkEmpty();
        this.meanImpl = meanImpl;
    }

    public StorelessUnivariateStatistic getVarianceImpl() {
        return this.varianceImpl;
    }

    public void setVarianceImpl(StorelessUnivariateStatistic varianceImpl) {
        this.checkEmpty();
        this.varianceImpl = varianceImpl;
    }

    private void checkEmpty() {
        if (this.n > 0L) {
            throw MathRuntimeException.createIllegalStateException((String)"{0} values have been added before statistic is configured", (Object[])new Object[]{this.n});
        }
    }

    public SummaryStatistics copy() {
        SummaryStatistics result = new SummaryStatistics();
        SummaryStatistics.copy((SummaryStatistics)this, (SummaryStatistics)result);
        return result;
    }

    public static void copy(SummaryStatistics source, SummaryStatistics dest) {
        dest.maxImpl = source.maxImpl.copy();
        dest.meanImpl = source.meanImpl.copy();
        dest.minImpl = source.minImpl.copy();
        dest.sumImpl = source.sumImpl.copy();
        dest.varianceImpl = source.varianceImpl.copy();
        dest.sumLogImpl = source.sumLogImpl.copy();
        dest.sumsqImpl = source.sumsqImpl.copy();
        dest.geoMeanImpl = source.getGeoMeanImpl() instanceof GeometricMean ? new GeometricMean((SumOfLogs)dest.sumLogImpl) : source.geoMeanImpl.copy();
        SecondMoment.copy((SecondMoment)source.secondMoment, (SecondMoment)dest.secondMoment);
        dest.n = source.n;
        if (source.geoMean == source.geoMeanImpl) {
            dest.geoMean = (GeometricMean)dest.geoMeanImpl;
        } else {
            GeometricMean.copy((GeometricMean)source.geoMean, (GeometricMean)dest.geoMean);
        }
        if (source.max == source.maxImpl) {
            dest.max = (Max)dest.maxImpl;
        } else {
            Max.copy((Max)source.max, (Max)dest.max);
        }
        if (source.mean == source.meanImpl) {
            dest.mean = (Mean)dest.meanImpl;
        } else {
            Mean.copy((Mean)source.mean, (Mean)dest.mean);
        }
        if (source.min == source.minImpl) {
            dest.min = (Min)dest.minImpl;
        } else {
            Min.copy((Min)source.min, (Min)dest.min);
        }
        if (source.sum == source.sumImpl) {
            dest.sum = (Sum)dest.sumImpl;
        } else {
            Sum.copy((Sum)source.sum, (Sum)dest.sum);
        }
        if (source.variance == source.varianceImpl) {
            dest.variance = (Variance)dest.varianceImpl;
        } else {
            Variance.copy((Variance)source.variance, (Variance)dest.variance);
        }
        if (source.sumLog == source.sumLogImpl) {
            dest.sumLog = (SumOfLogs)dest.sumLogImpl;
        } else {
            SumOfLogs.copy((SumOfLogs)source.sumLog, (SumOfLogs)dest.sumLog);
        }
        if (source.sumsq == source.sumsqImpl) {
            dest.sumsq = (SumOfSquares)dest.sumsqImpl;
        } else {
            SumOfSquares.copy((SumOfSquares)source.sumsq, (SumOfSquares)dest.sumsq);
        }
    }
}

