/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import java.io.Serializable;
import org.apache.commons.math.stat.descriptive.StatisticalSummary;
import org.apache.commons.math.util.MathUtils;

public class StatisticalSummaryValues
implements Serializable,
StatisticalSummary {
    private static final long serialVersionUID = -5108854841843722536L;
    private final double mean;
    private final double variance;
    private final long n;
    private final double max;
    private final double min;
    private final double sum;

    public StatisticalSummaryValues(double mean, double variance, long n, double max, double min, double sum) {
        this.mean = mean;
        this.variance = variance;
        this.n = n;
        this.max = max;
        this.min = min;
        this.sum = sum;
    }

    public double getMax() {
        return this.max;
    }

    public double getMean() {
        return this.mean;
    }

    public double getMin() {
        return this.min;
    }

    public long getN() {
        return this.n;
    }

    public double getSum() {
        return this.sum;
    }

    public double getStandardDeviation() {
        return Math.sqrt(this.variance);
    }

    public double getVariance() {
        return this.variance;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof StatisticalSummaryValues)) {
            return false;
        }
        StatisticalSummaryValues stat = (StatisticalSummaryValues)object;
        return MathUtils.equals((double)stat.getMax(), (double)this.getMax()) && MathUtils.equals((double)stat.getMean(), (double)this.getMean()) && MathUtils.equals((double)stat.getMin(), (double)this.getMin()) && MathUtils.equals((double)stat.getN(), (double)this.getN()) && MathUtils.equals((double)stat.getSum(), (double)this.getSum()) && MathUtils.equals((double)stat.getVariance(), (double)this.getVariance());
    }

    public int hashCode() {
        int result = 31 + MathUtils.hash((double)this.getMax());
        result = result * 31 + MathUtils.hash((double)this.getMean());
        result = result * 31 + MathUtils.hash((double)this.getMin());
        result = result * 31 + MathUtils.hash((double)this.getN());
        result = result * 31 + MathUtils.hash((double)this.getSum());
        result = result * 31 + MathUtils.hash((double)this.getVariance());
        return result;
    }
}

