/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat.descriptive;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.stat.descriptive.UnivariateStatistic;

public abstract class AbstractUnivariateStatistic
implements UnivariateStatistic {
    public double evaluate(double[] values) {
        this.test(values, 0, 0);
        return this.evaluate(values, 0, values.length);
    }

    public abstract double evaluate(double[] var1, int var2, int var3);

    public abstract UnivariateStatistic copy();

    protected boolean test(double[] values, int begin, int length) {
        if (values == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"input values array is null", (Object[])new Object[0]);
        }
        if (begin < 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"start position cannot be negative ({0})", (Object[])new Object[]{begin});
        }
        if (length < 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"length cannot be negative ({0})", (Object[])new Object[]{length});
        }
        if (begin + length > values.length) {
            throw MathRuntimeException.createIllegalArgumentException((String)"subarray ends after array end", (Object[])new Object[0]);
        }
        return length != 0;
    }

    protected boolean test(double[] values, double[] weights, int begin, int length) {
        if (weights == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"input weights array is null", (Object[])new Object[0]);
        }
        if (weights.length != values.length) {
            throw MathRuntimeException.createIllegalArgumentException((String)"Different number of weights and values", (Object[])new Object[0]);
        }
        boolean containsPositiveWeight = false;
        for (int i = begin; i < begin + length; ++i) {
            if (Double.isNaN(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException((String)"NaN weight at index {0}", (Object[])new Object[]{i});
            }
            if (Double.isInfinite(weights[i])) {
                throw MathRuntimeException.createIllegalArgumentException((String)"Infinite weight at index {0}", (Object[])new Object[]{i});
            }
            if (weights[i] < 0.0) {
                throw MathRuntimeException.createIllegalArgumentException((String)"negative weight {0} at index {1} ", (Object[])new Object[]{weights[i], i});
            }
            if (containsPositiveWeight || !(weights[i] > 0.0)) continue;
            containsPositiveWeight = true;
        }
        if (!containsPositiveWeight) {
            throw MathRuntimeException.createIllegalArgumentException((String)"weight array must contain at least one non-zero value", (Object[])new Object[0]);
        }
        return this.test(values, begin, length);
    }
}

