/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.stat;

import java.io.Serializable;
import java.text.NumberFormat;
import java.util.Comparator;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.stat.Frequency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Frequency
implements Serializable {
    private static final long serialVersionUID = -3845586908418844111L;
    private final TreeMap<Comparable<?>, Long> freqTable;

    public Frequency() {
        this.freqTable = new TreeMap();
    }

    public Frequency(Comparator<?> comparator) {
        this.freqTable = new TreeMap(comparator);
    }

    public String toString() {
        NumberFormat nf = NumberFormat.getPercentInstance();
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("Value \t Freq. \t Pct. \t Cum Pct. \n");
        for (Comparable value : this.freqTable.keySet()) {
            outBuffer.append(value);
            outBuffer.append('\t');
            outBuffer.append(this.getCount(value));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getPct(value)));
            outBuffer.append('\t');
            outBuffer.append(nf.format(this.getCumPct(value)));
            outBuffer.append('\n');
        }
        return outBuffer.toString();
    }

    @Deprecated
    public void addValue(Object v) {
        if (!(v instanceof Comparable)) {
            throw MathRuntimeException.createIllegalArgumentException((String)"class ({0}) does not implement Comparable", (Object[])new Object[]{v.getClass().getName()});
        }
        this.addValue((Comparable)v);
    }

    public void addValue(Comparable<?> v) {
        Long obj = v;
        if (v instanceof Integer) {
            obj = ((Integer)((Object)v)).longValue();
        }
        try {
            Long count = (Long)this.freqTable.get(obj);
            if (count == null) {
                this.freqTable.put(obj, 1L);
            } else {
                this.freqTable.put(obj, count + 1L);
            }
        }
        catch (ClassCastException ex) {
            throw MathRuntimeException.createIllegalArgumentException((String)"instance of class {0} not comparable to existing values", (Object[])new Object[]{v.getClass().getName()});
        }
    }

    public void addValue(int v) {
        this.addValue((Comparable)Long.valueOf(v));
    }

    @Deprecated
    public void addValue(Integer v) {
        this.addValue((Comparable)Long.valueOf(v.longValue()));
    }

    public void addValue(long v) {
        this.addValue((Comparable)Long.valueOf(v));
    }

    public void addValue(char v) {
        this.addValue((Comparable)Character.valueOf(v));
    }

    public void clear() {
        this.freqTable.clear();
    }

    public Iterator<Comparable<?>> valuesIterator() {
        return this.freqTable.keySet().iterator();
    }

    public long getSumFreq() {
        long result = 0L;
        Iterator iterator = this.freqTable.values().iterator();
        while (iterator.hasNext()) {
            result += ((Long)iterator.next()).longValue();
        }
        return result;
    }

    @Deprecated
    public long getCount(Object v) {
        return this.getCount((Comparable)v);
    }

    public long getCount(Comparable<?> v) {
        if (v instanceof Integer) {
            return this.getCount(((Integer)v).longValue());
        }
        long result = 0L;
        try {
            Long count = (Long)this.freqTable.get(v);
            if (count != null) {
                result = count;
            }
        }
        catch (ClassCastException ex) {
            // empty catch block
        }
        return result;
    }

    public long getCount(int v) {
        return this.getCount((Comparable)Long.valueOf(v));
    }

    public long getCount(long v) {
        return this.getCount((Comparable)Long.valueOf(v));
    }

    public long getCount(char v) {
        return this.getCount((Comparable)Character.valueOf(v));
    }

    @Deprecated
    public double getPct(Object v) {
        return this.getPct((Comparable)v);
    }

    public double getPct(Comparable<?> v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCount(v) / (double)sumFreq;
    }

    public double getPct(int v) {
        return this.getPct((Comparable)Long.valueOf(v));
    }

    public double getPct(long v) {
        return this.getPct((Comparable)Long.valueOf(v));
    }

    public double getPct(char v) {
        return this.getPct((Comparable)Character.valueOf(v));
    }

    @Deprecated
    public long getCumFreq(Object v) {
        return this.getCumFreq((Comparable)v);
    }

    public long getCumFreq(Comparable<?> v) {
        if (this.getSumFreq() == 0L) {
            return 0L;
        }
        if (v instanceof Integer) {
            return this.getCumFreq(((Integer)v).longValue());
        }
        NaturalComparator c = this.freqTable.comparator();
        if (c == null) {
            c = new NaturalComparator(null);
        }
        long result = 0L;
        try {
            Long value = (Long)this.freqTable.get(v);
            if (value != null) {
                result = value;
            }
        }
        catch (ClassCastException ex) {
            return result;
        }
        if (c.compare(v, this.freqTable.firstKey()) < 0) {
            return 0L;
        }
        if (c.compare(v, this.freqTable.lastKey()) >= 0) {
            return this.getSumFreq();
        }
        Iterator values = this.valuesIterator();
        while (values.hasNext()) {
            Comparable nextValue = (Comparable)values.next();
            if (c.compare(v, nextValue) > 0) {
                result += this.getCount(nextValue);
                continue;
            }
            return result;
        }
        return result;
    }

    public long getCumFreq(int v) {
        return this.getCumFreq((Comparable)Long.valueOf(v));
    }

    public long getCumFreq(long v) {
        return this.getCumFreq((Comparable)Long.valueOf(v));
    }

    public long getCumFreq(char v) {
        return this.getCumFreq((Comparable)Character.valueOf(v));
    }

    @Deprecated
    public double getCumPct(Object v) {
        return this.getCumPct((Comparable)v);
    }

    public double getCumPct(Comparable<?> v) {
        long sumFreq = this.getSumFreq();
        if (sumFreq == 0L) {
            return Double.NaN;
        }
        return (double)this.getCumFreq(v) / (double)sumFreq;
    }

    public double getCumPct(int v) {
        return this.getCumPct((Comparable)Long.valueOf(v));
    }

    public double getCumPct(long v) {
        return this.getCumPct((Comparable)Long.valueOf(v));
    }

    public double getCumPct(char v) {
        return this.getCumPct((Comparable)Character.valueOf(v));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.freqTable == null ? 0 : this.freqTable.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof Frequency)) {
            return false;
        }
        Frequency other = (Frequency)obj;
        return !(this.freqTable == null ? other.freqTable != null : !this.freqTable.equals(other.freqTable));
    }
}

