/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.general;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MaxEvaluationsExceededException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableMultivariateVectorialFunction;
import org.apache.commons.math.analysis.MultivariateMatrixFunction;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.optimization.DifferentiableMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.SimpleVectorialValueChecker;
import org.apache.commons.math.optimization.VectorialConvergenceChecker;
import org.apache.commons.math.optimization.VectorialPointValuePair;

public abstract class AbstractLeastSquaresOptimizer
implements DifferentiableMultivariateVectorialOptimizer {
    public static final int DEFAULT_MAX_ITERATIONS = 100;
    protected VectorialConvergenceChecker checker;
    protected double[][] jacobian;
    protected int cols;
    protected int rows;
    protected double[] targetValues;
    protected double[] residualsWeights;
    protected double[] point;
    protected double[] objective;
    protected double[] residuals;
    protected double cost;
    private int maxIterations;
    private int iterations;
    private int maxEvaluations;
    private int objectiveEvaluations;
    private int jacobianEvaluations;
    private DifferentiableMultivariateVectorialFunction function;
    private MultivariateMatrixFunction jF;

    protected AbstractLeastSquaresOptimizer() {
        this.setConvergenceChecker((VectorialConvergenceChecker)new SimpleVectorialValueChecker());
        this.setMaxIterations(100);
        this.setMaxEvaluations(Integer.MAX_VALUE);
    }

    public void setMaxIterations(int maxIterations) {
        this.maxIterations = maxIterations;
    }

    public int getMaxIterations() {
        return this.maxIterations;
    }

    public int getIterations() {
        return this.iterations;
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.objectiveEvaluations;
    }

    public int getJacobianEvaluations() {
        return this.jacobianEvaluations;
    }

    public void setConvergenceChecker(VectorialConvergenceChecker convergenceChecker) {
        this.checker = convergenceChecker;
    }

    public VectorialConvergenceChecker getConvergenceChecker() {
        return this.checker;
    }

    protected void incrementIterationsCounter() throws OptimizationException {
        if (++this.iterations > this.maxIterations) {
            throw new OptimizationException((Throwable)new MaxIterationsExceededException(this.maxIterations));
        }
    }

    protected void updateJacobian() throws FunctionEvaluationException {
        ++this.jacobianEvaluations;
        this.jacobian = this.jF.value(this.point);
        if (this.jacobian.length != this.rows) {
            throw new FunctionEvaluationException(this.point, "dimension mismatch {0} != {1}", new Object[]{this.jacobian.length, this.rows});
        }
        for (int i = 0; i < this.rows; ++i) {
            double[] ji = this.jacobian[i];
            double factor = -Math.sqrt(this.residualsWeights[i]);
            int j = 0;
            while (j < this.cols) {
                int n = j++;
                ji[n] = ji[n] * factor;
            }
        }
    }

    protected void updateResidualsAndCost() throws FunctionEvaluationException {
        if (++this.objectiveEvaluations > this.maxEvaluations) {
            throw new FunctionEvaluationException((Throwable)new MaxEvaluationsExceededException(this.maxEvaluations), this.point);
        }
        this.objective = this.function.value(this.point);
        if (this.objective.length != this.rows) {
            throw new FunctionEvaluationException(this.point, "dimension mismatch {0} != {1}", new Object[]{this.objective.length, this.rows});
        }
        this.cost = 0.0;
        int index = 0;
        for (int i = 0; i < this.rows; ++i) {
            double residual;
            this.residuals[i] = residual = this.targetValues[i] - this.objective[i];
            this.cost += this.residualsWeights[i] * residual * residual;
            index += this.cols;
        }
        this.cost = Math.sqrt(this.cost);
    }

    public double getRMS() {
        double criterion = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            double residual = this.residuals[i];
            criterion += this.residualsWeights[i] * residual * residual;
        }
        return Math.sqrt(criterion / (double)this.rows);
    }

    public double getChiSquare() {
        double chiSquare = 0.0;
        for (int i = 0; i < this.rows; ++i) {
            double residual = this.residuals[i];
            chiSquare += residual * residual / this.residualsWeights[i];
        }
        return chiSquare;
    }

    public double[][] getCovariances() throws FunctionEvaluationException, OptimizationException {
        this.updateJacobian();
        double[][] jTj = new double[this.cols][this.cols];
        for (int i = 0; i < this.cols; ++i) {
            for (int j = i; j < this.cols; ++j) {
                double sum = 0.0;
                for (int k = 0; k < this.rows; ++k) {
                    sum += this.jacobian[k][i] * this.jacobian[k][j];
                }
                jTj[i][j] = sum;
                jTj[j][i] = sum;
            }
        }
        try {
            RealMatrix inverse = new LUDecompositionImpl(MatrixUtils.createRealMatrix((double[][])jTj)).getSolver().getInverse();
            return inverse.getData();
        }
        catch (InvalidMatrixException ime) {
            throw new OptimizationException("unable to compute covariances: singular problem", new Object[0]);
        }
    }

    public double[] guessParametersErrors() throws FunctionEvaluationException, OptimizationException {
        if (this.rows <= this.cols) {
            throw new OptimizationException("no degrees of freedom ({0} measurements, {1} parameters)", new Object[]{this.rows, this.cols});
        }
        double[] errors = new double[this.cols];
        double c = Math.sqrt(this.getChiSquare() / (double)(this.rows - this.cols));
        double[][] covar = this.getCovariances();
        for (int i = 0; i < errors.length; ++i) {
            errors[i] = Math.sqrt(covar[i][i]) * c;
        }
        return errors;
    }

    public VectorialPointValuePair optimize(DifferentiableMultivariateVectorialFunction f, double[] target, double[] weights, double[] startPoint) throws FunctionEvaluationException, OptimizationException, IllegalArgumentException {
        if (target.length != weights.length) {
            throw new OptimizationException("dimension mismatch {0} != {1}", new Object[]{target.length, weights.length});
        }
        this.iterations = 0;
        this.objectiveEvaluations = 0;
        this.jacobianEvaluations = 0;
        this.function = f;
        this.jF = f.jacobian();
        this.targetValues = (double[])target.clone();
        this.residualsWeights = (double[])weights.clone();
        this.point = (double[])startPoint.clone();
        this.residuals = new double[target.length];
        this.rows = target.length;
        this.cols = this.point.length;
        this.jacobian = new double[this.rows][this.cols];
        this.cost = Double.POSITIVE_INFINITY;
        return this.doOptimize();
    }

    protected abstract VectorialPointValuePair doOptimize() throws FunctionEvaluationException, OptimizationException, IllegalArgumentException;
}

