/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization.fitting;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.optimization.DifferentiableMultivariateVectorialOptimizer;
import org.apache.commons.math.optimization.OptimizationException;
import org.apache.commons.math.optimization.fitting.CurveFitter;
import org.apache.commons.math.optimization.fitting.HarmonicCoefficientsGuesser;
import org.apache.commons.math.optimization.fitting.HarmonicFitter;
import org.apache.commons.math.optimization.fitting.HarmonicFunction;
import org.apache.commons.math.optimization.fitting.ParametricRealFunction;
import org.apache.commons.math.optimization.fitting.WeightedObservedPoint;

public class HarmonicFitter {
    private final CurveFitter fitter;
    private double[] parameters;

    public HarmonicFitter(DifferentiableMultivariateVectorialOptimizer optimizer) {
        this.fitter = new CurveFitter(optimizer);
        this.parameters = null;
    }

    public HarmonicFitter(DifferentiableMultivariateVectorialOptimizer optimizer, double[] initialGuess) {
        this.fitter = new CurveFitter(optimizer);
        this.parameters = (double[])initialGuess.clone();
    }

    public void addObservedPoint(double weight, double x, double y) {
        this.fitter.addObservedPoint(weight, x, y);
    }

    public HarmonicFunction fit() throws OptimizationException {
        try {
            if (this.parameters == null) {
                WeightedObservedPoint[] observations = this.fitter.getObservations();
                if (observations.length < 4) {
                    throw new OptimizationException("sample contains {0} observed points, at least {1} are required", new Object[]{observations.length, 4});
                }
                HarmonicCoefficientsGuesser guesser = new HarmonicCoefficientsGuesser(observations);
                guesser.guess();
                this.parameters = new double[]{guesser.getGuessedAmplitude(), guesser.getGuessedPulsation(), guesser.getGuessedPhase()};
            }
            double[] fitted = this.fitter.fit((ParametricRealFunction)new ParametricHarmonicFunction(null), this.parameters);
            return new HarmonicFunction(fitted[0], fitted[1], fitted[2]);
        }
        catch (FunctionEvaluationException fee) {
            throw MathRuntimeException.createInternalError((Throwable)fee);
        }
    }
}

