/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.optimization;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.MultivariateRealFunction;
import org.apache.commons.math.analysis.MultivariateVectorialFunction;
import org.apache.commons.math.linear.RealMatrix;

public class LeastSquaresConverter
implements MultivariateRealFunction {
    private final MultivariateVectorialFunction function;
    private final double[] observations;
    private final double[] weights;
    private final RealMatrix scale;

    public LeastSquaresConverter(MultivariateVectorialFunction function, double[] observations) {
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = null;
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorialFunction function, double[] observations, double[] weights) throws IllegalArgumentException {
        if (observations.length != weights.length) {
            throw MathRuntimeException.createIllegalArgumentException((String)"dimension mismatch {0} != {1}", (Object[])new Object[]{observations.length, weights.length});
        }
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = (double[])weights.clone();
        this.scale = null;
    }

    public LeastSquaresConverter(MultivariateVectorialFunction function, double[] observations, RealMatrix scale) throws IllegalArgumentException {
        if (observations.length != scale.getColumnDimension()) {
            throw MathRuntimeException.createIllegalArgumentException((String)"dimension mismatch {0} != {1}", (Object[])new Object[]{observations.length, scale.getColumnDimension()});
        }
        this.function = function;
        this.observations = (double[])observations.clone();
        this.weights = null;
        this.scale = scale.copy();
    }

    public double value(double[] point) throws FunctionEvaluationException {
        double[] residuals = this.function.value(point);
        if (residuals.length != this.observations.length) {
            throw new FunctionEvaluationException(point, "dimension mismatch {0} != {1}", new Object[]{residuals.length, this.observations.length});
        }
        for (int i = 0; i < residuals.length; ++i) {
            int n = i;
            residuals[n] = residuals[n] - this.observations[i];
        }
        double sumSquares = 0.0;
        if (this.weights != null) {
            for (int i = 0; i < residuals.length; ++i) {
                double ri = residuals[i];
                sumSquares += this.weights[i] * ri * ri;
            }
        } else if (this.scale != null) {
            for (double yi : this.scale.operate(residuals)) {
                sumSquares += yi * yi;
            }
        } else {
            for (double ri : residuals) {
                sumSquares += ri * ri;
            }
        }
        return sumSquares;
    }
}

