/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode.jacobians;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.events.EventHandler;
import org.apache.commons.math.ode.jacobians.EventHandlerWithJacobians;
import org.apache.commons.math.ode.jacobians.FirstOrderIntegratorWithJacobians;
import org.apache.commons.math.ode.jacobians.ODEWithJacobians;
import org.apache.commons.math.ode.jacobians.ParameterizedODE;
import org.apache.commons.math.ode.jacobians.StepHandlerWithJacobians;
import org.apache.commons.math.ode.sampling.StepHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 * Exception performing whole class analysis ignored.
 */
public class FirstOrderIntegratorWithJacobians {
    private final FirstOrderIntegrator integrator;
    private final ODEWithJacobians ode;
    private int maxEvaluations;
    private int evaluations;

    public FirstOrderIntegratorWithJacobians(FirstOrderIntegrator integrator, ParameterizedODE ode, double[] p, double[] hY, double[] hP) {
        this.checkDimension(ode.getDimension(), (Object)hY);
        this.checkDimension(ode.getParametersDimension(), (Object)p);
        this.checkDimension(ode.getParametersDimension(), (Object)hP);
        this.integrator = integrator;
        this.ode = new FiniteDifferencesWrapper(this, ode, p, hY, hP);
        this.setMaxEvaluations(-1);
    }

    public FirstOrderIntegratorWithJacobians(FirstOrderIntegrator integrator, ODEWithJacobians ode) {
        this.integrator = integrator;
        this.ode = ode;
        this.setMaxEvaluations(-1);
    }

    public void addStepHandler(StepHandlerWithJacobians handler) {
        int n = this.ode.getDimension();
        int k = this.ode.getParametersDimension();
        this.integrator.addStepHandler((StepHandler)new StepHandlerWrapper(handler, n, k));
    }

    public Collection<StepHandlerWithJacobians> getStepHandlers() {
        ArrayList<StepHandlerWithJacobians> handlers = new ArrayList<StepHandlerWithJacobians>();
        for (StepHandler handler : this.integrator.getStepHandlers()) {
            if (!(handler instanceof StepHandlerWrapper)) continue;
            handlers.add(((StepHandlerWrapper)handler).getHandler());
        }
        return handlers;
    }

    public void clearStepHandlers() {
        this.integrator.clearStepHandlers();
    }

    public void addEventHandler(EventHandlerWithJacobians handler, double maxCheckInterval, double convergence, int maxIterationCount) {
        int n = this.ode.getDimension();
        int k = this.ode.getParametersDimension();
        this.integrator.addEventHandler((EventHandler)new EventHandlerWrapper(handler, n, k), maxCheckInterval, convergence, maxIterationCount);
    }

    public Collection<EventHandlerWithJacobians> getEventHandlers() {
        ArrayList<EventHandlerWithJacobians> handlers = new ArrayList<EventHandlerWithJacobians>();
        for (EventHandler handler : this.integrator.getEventHandlers()) {
            if (!(handler instanceof EventHandlerWrapper)) continue;
            handlers.add(((EventHandlerWrapper)handler).getHandler());
        }
        return handlers;
    }

    public void clearEventHandlers() {
        this.integrator.clearEventHandlers();
    }

    public double integrate(double t0, double[] y0, double[][] dY0dP, double t, double[] y, double[][] dYdY0, double[][] dYdP) throws DerivativeException, IntegratorException {
        int n = this.ode.getDimension();
        int k = this.ode.getParametersDimension();
        this.checkDimension(n, (Object)y0);
        this.checkDimension(n, (Object)y);
        this.checkDimension(n, (Object)dYdY0);
        this.checkDimension(n, (Object)dYdY0[0]);
        if (k != 0) {
            this.checkDimension(n, (Object)dY0dP);
            this.checkDimension(k, (Object)dY0dP[0]);
            this.checkDimension(n, (Object)dYdP);
            this.checkDimension(k, (Object)dYdP[0]);
        }
        double[] z = new double[n * (1 + n + k)];
        System.arraycopy(y0, 0, z, 0, n);
        for (int i = 0; i < n; ++i) {
            z[i * (1 + n) + n] = 1.0;
            System.arraycopy(dY0dP[i], 0, z, n * (n + 1) + i * k, k);
        }
        this.evaluations = 0;
        double stopTime = this.integrator.integrate((FirstOrderDifferentialEquations)new MappingWrapper(this), t0, z, t, z);
        FirstOrderIntegratorWithJacobians.dispatchCompoundState((double[])z, (double[])y, (double[][])dYdY0, (double[][])dYdP);
        return stopTime;
    }

    private static void dispatchCompoundState(double[] z, double[] y, double[][] dydy0, double[][] dydp) {
        int i;
        int n = y.length;
        int k = dydp[0].length;
        System.arraycopy(z, 0, y, 0, n);
        for (i = 0; i < n; ++i) {
            System.arraycopy(z, n * (i + 1), dydy0[i], 0, n);
        }
        for (i = 0; i < n; ++i) {
            System.arraycopy(z, n * (n + 1) + i * k, dydp[i], 0, k);
        }
    }

    public double getCurrentStepStart() {
        return this.integrator.getCurrentStepStart();
    }

    public double getCurrentSignedStepsize() {
        return this.integrator.getCurrentSignedStepsize();
    }

    public void setMaxEvaluations(int maxEvaluations) {
        this.maxEvaluations = maxEvaluations < 0 ? Integer.MAX_VALUE : maxEvaluations;
    }

    public int getMaxEvaluations() {
        return this.maxEvaluations;
    }

    public int getEvaluations() {
        return this.evaluations;
    }

    private void checkDimension(int expected, Object array) throws IllegalArgumentException {
        int arrayDimension;
        int n = arrayDimension = array == null ? 0 : Array.getLength(array);
        if (arrayDimension != expected) {
            throw MathRuntimeException.createIllegalArgumentException((String)"dimension mismatch {0} != {1}", (Object[])new Object[]{arrayDimension, expected});
        }
    }

    static /* synthetic */ ODEWithJacobians access$000(FirstOrderIntegratorWithJacobians x0) {
        return x0.ode;
    }

    static /* synthetic */ int access$104(FirstOrderIntegratorWithJacobians x0) {
        return ++x0.evaluations;
    }

    static /* synthetic */ int access$200(FirstOrderIntegratorWithJacobians x0) {
        return x0.maxEvaluations;
    }

    static /* synthetic */ int access$112(FirstOrderIntegratorWithJacobians x0, int x1) {
        return x0.evaluations += x1;
    }

    static /* synthetic */ int access$100(FirstOrderIntegratorWithJacobians x0) {
        return x0.evaluations;
    }

    static /* synthetic */ void access$300(double[] x0, double[] x1, double[][] x2, double[][] x3) {
        FirstOrderIntegratorWithJacobians.dispatchCompoundState((double[])x0, (double[])x1, (double[][])x2, (double[][])x3);
    }
}

