/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.ode;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.Array2DRowRealMatrix;
import org.apache.commons.math.ode.DerivativeException;
import org.apache.commons.math.ode.FirstOrderDifferentialEquations;
import org.apache.commons.math.ode.FirstOrderIntegrator;
import org.apache.commons.math.ode.IntegratorException;
import org.apache.commons.math.ode.MultistepIntegrator;
import org.apache.commons.math.ode.ODEIntegrator;
import org.apache.commons.math.ode.nonstiff.AdaptiveStepsizeIntegrator;
import org.apache.commons.math.ode.nonstiff.DormandPrince853Integrator;
import org.apache.commons.math.ode.sampling.StepHandler;

public abstract class MultistepIntegrator
extends AdaptiveStepsizeIntegrator {
    protected double[] scaled;
    protected Array2DRowRealMatrix nordsieck;
    private FirstOrderIntegrator starter;
    private final int nSteps;
    private double exp;
    private double safety;
    private double minReduction;
    private double maxGrowth;

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double scalAbsoluteTolerance, double scalRelativeTolerance) {
        super(name, minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        if (nSteps <= 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} method needs at least one previous point", (Object[])new Object[]{name});
        }
        this.starter = new DormandPrince853Integrator(minStep, maxStep, scalAbsoluteTolerance, scalRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(Math.pow(2.0, -this.exp));
    }

    protected MultistepIntegrator(String name, int nSteps, int order, double minStep, double maxStep, double[] vecAbsoluteTolerance, double[] vecRelativeTolerance) {
        super(name, minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.starter = new DormandPrince853Integrator(minStep, maxStep, vecAbsoluteTolerance, vecRelativeTolerance);
        this.nSteps = nSteps;
        this.exp = -1.0 / (double)order;
        this.setSafety(0.9);
        this.setMinReduction(0.2);
        this.setMaxGrowth(Math.pow(2.0, -this.exp));
    }

    public ODEIntegrator getStarterIntegrator() {
        return this.starter;
    }

    public void setStarterIntegrator(FirstOrderIntegrator starterIntegrator) {
        this.starter = starterIntegrator;
    }

    protected void start(double t0, double[] y0, double t) throws DerivativeException, IntegratorException {
        block2: {
            this.starter.clearEventHandlers();
            this.starter.clearStepHandlers();
            this.starter.addStepHandler((StepHandler)new NordsieckInitializer(this, y0.length));
            try {
                this.starter.integrate((FirstOrderDifferentialEquations)new CountingDifferentialEquations(this, y0.length), t0, y0, t, new double[y0.length]);
            }
            catch (DerivativeException de) {
                if (de instanceof InitializationCompletedMarkerException) break block2;
                throw de;
            }
        }
        this.starter.clearStepHandlers();
    }

    protected abstract Array2DRowRealMatrix initializeHighOrderDerivatives(double[] var1, double[][] var2);

    public double getMinReduction() {
        return this.minReduction;
    }

    public void setMinReduction(double minReduction) {
        this.minReduction = minReduction;
    }

    public double getMaxGrowth() {
        return this.maxGrowth;
    }

    public void setMaxGrowth(double maxGrowth) {
        this.maxGrowth = maxGrowth;
    }

    public double getSafety() {
        return this.safety;
    }

    public void setSafety(double safety) {
        this.safety = safety;
    }

    protected double computeStepGrowShrinkFactor(double error) {
        return Math.min(this.maxGrowth, Math.max(this.minReduction, this.safety * Math.pow(error, this.exp)));
    }

    static /* synthetic */ int access$000(MultistepIntegrator x0) {
        return x0.nSteps;
    }
}

