/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.linear;

import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.linear.AnyMatrix;
import org.apache.commons.math.linear.ArrayRealVector;
import org.apache.commons.math.linear.DecompositionSolver;
import org.apache.commons.math.linear.InvalidMatrixException;
import org.apache.commons.math.linear.LUDecompositionImpl;
import org.apache.commons.math.linear.MatrixIndexException;
import org.apache.commons.math.linear.MatrixUtils;
import org.apache.commons.math.linear.MatrixVisitorException;
import org.apache.commons.math.linear.NonSquareMatrixException;
import org.apache.commons.math.linear.RealMatrix;
import org.apache.commons.math.linear.RealMatrixChangingVisitor;
import org.apache.commons.math.linear.RealMatrixPreservingVisitor;
import org.apache.commons.math.linear.RealVector;
import org.apache.commons.math.util.MathUtils;

public abstract class AbstractRealMatrix
implements RealMatrix {
    @Deprecated
    private DecompositionSolver lu;

    protected AbstractRealMatrix() {
        this.lu = null;
    }

    protected AbstractRealMatrix(int rowDimension, int columnDimension) throws IllegalArgumentException {
        if (rowDimension <= 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"invalid row dimension {0} (must be positive)", (Object[])new Object[]{rowDimension});
        }
        if (columnDimension <= 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"invalid column dimension {0} (must be positive)", (Object[])new Object[]{columnDimension});
        }
        this.lu = null;
    }

    public abstract RealMatrix createMatrix(int var1, int var2) throws IllegalArgumentException;

    public abstract RealMatrix copy();

    public RealMatrix add(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkAdditionCompatible((AnyMatrix)this, (AnyMatrix)m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) + m.getEntry(row, col));
            }
        }
        return out;
    }

    public RealMatrix subtract(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkSubtractionCompatible((AnyMatrix)this, (AnyMatrix)m);
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) - m.getEntry(row, col));
            }
        }
        return out;
    }

    public RealMatrix scalarAdd(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) + d);
            }
        }
        return out;
    }

    public RealMatrix scalarMultiply(double d) {
        int rowCount = this.getRowDimension();
        int columnCount = this.getColumnDimension();
        RealMatrix out = this.createMatrix(rowCount, columnCount);
        for (int row = 0; row < rowCount; ++row) {
            for (int col = 0; col < columnCount; ++col) {
                out.setEntry(row, col, this.getEntry(row, col) * d);
            }
        }
        return out;
    }

    public RealMatrix multiply(RealMatrix m) throws IllegalArgumentException {
        MatrixUtils.checkMultiplicationCompatible((AnyMatrix)this, (AnyMatrix)m);
        int nRows = this.getRowDimension();
        int nCols = m.getColumnDimension();
        int nSum = this.getColumnDimension();
        RealMatrix out = this.createMatrix(nRows, nCols);
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                double sum = 0.0;
                for (int i = 0; i < nSum; ++i) {
                    sum += this.getEntry(row, i) * m.getEntry(i, col);
                }
                out.setEntry(row, col, sum);
            }
        }
        return out;
    }

    public RealMatrix preMultiply(RealMatrix m) throws IllegalArgumentException {
        return m.multiply((RealMatrix)this);
    }

    public double[][] getData() {
        double[][] data = new double[this.getRowDimension()][this.getColumnDimension()];
        for (int i = 0; i < data.length; ++i) {
            double[] dataI = data[i];
            for (int j = 0; j < dataI.length; ++j) {
                dataI[j] = this.getEntry(i, j);
            }
        }
        return data;
    }

    public double getNorm() {
        return this.walkInColumnOrder((RealMatrixPreservingVisitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public double getFrobeniusNorm() {
        return this.walkInOptimizedOrder((RealMatrixPreservingVisitor)new /* Unavailable Anonymous Inner Class!! */);
    }

    public RealMatrix getSubMatrix(int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int)startRow, (int)endRow, (int)startColumn, (int)endColumn);
        RealMatrix subMatrix = this.createMatrix(endRow - startRow + 1, endColumn - startColumn + 1);
        for (int i = startRow; i <= endRow; ++i) {
            for (int j = startColumn; j <= endColumn; ++j) {
                subMatrix.setEntry(i - startRow, j - startColumn, this.getEntry(i, j));
            }
        }
        return subMatrix;
    }

    public RealMatrix getSubMatrix(int[] selectedRows, int[] selectedColumns) throws MatrixIndexException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int[])selectedRows, (int[])selectedColumns);
        RealMatrix subMatrix = this.createMatrix(selectedRows.length, selectedColumns.length);
        subMatrix.walkInOptimizedOrder((RealMatrixChangingVisitor)new /* Unavailable Anonymous Inner Class!! */);
        return subMatrix;
    }

    public void copySubMatrix(int startRow, int endRow, int startColumn, int endColumn, double[][] destination) throws MatrixIndexException, IllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int)startRow, (int)endRow, (int)startColumn, (int)endColumn);
        int rowsCount = endRow + 1 - startRow;
        int columnsCount = endColumn + 1 - startColumn;
        if (destination.length < rowsCount || destination[0].length < columnsCount) {
            throw MathRuntimeException.createIllegalArgumentException((String)"dimensions mismatch: got {0}x{1} but expected {2}x{3}", (Object[])new Object[]{destination.length, destination[0].length, rowsCount, columnsCount});
        }
        this.walkInOptimizedOrder((RealMatrixPreservingVisitor)new /* Unavailable Anonymous Inner Class!! */, startRow, endRow, startColumn, endColumn);
    }

    public void copySubMatrix(int[] selectedRows, int[] selectedColumns, double[][] destination) throws MatrixIndexException, IllegalArgumentException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int[])selectedRows, (int[])selectedColumns);
        if (destination.length < selectedRows.length || destination[0].length < selectedColumns.length) {
            throw MathRuntimeException.createIllegalArgumentException((String)"dimensions mismatch: got {0}x{1} but expected {2}x{3}", (Object[])new Object[]{destination.length, destination[0].length, selectedRows.length, selectedColumns.length});
        }
        for (int i = 0; i < selectedRows.length; ++i) {
            double[] destinationI = destination[i];
            for (int j = 0; j < selectedColumns.length; ++j) {
                destinationI[j] = this.getEntry(selectedRows[i], selectedColumns[j]);
            }
        }
    }

    public void setSubMatrix(double[][] subMatrix, int row, int column) throws MatrixIndexException {
        int nRows = subMatrix.length;
        if (nRows == 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"matrix must have at least one row", (Object[])new Object[0]);
        }
        int nCols = subMatrix[0].length;
        if (nCols == 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"matrix must have at least one column", (Object[])new Object[0]);
        }
        for (int r = 1; r < nRows; ++r) {
            if (subMatrix[r].length == nCols) continue;
            throw MathRuntimeException.createIllegalArgumentException((String)"some rows have length {0} while others have length {1}", (Object[])new Object[]{nCols, subMatrix[r].length});
        }
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)(nRows + row - 1));
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)(nCols + column - 1));
        for (int i = 0; i < nRows; ++i) {
            for (int j = 0; j < nCols; ++j) {
                this.setEntry(row + i, column + j, subMatrix[i][j]);
            }
        }
        this.lu = null;
    }

    public RealMatrix getRowMatrix(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        int nCols = this.getColumnDimension();
        RealMatrix out = this.createMatrix(1, nCols);
        for (int i = 0; i < nCols; ++i) {
            out.setEntry(0, i, this.getEntry(row, i));
        }
        return out;
    }

    public void setRowMatrix(int row, RealMatrix matrix) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        int nCols = this.getColumnDimension();
        if (matrix.getRowDimension() != 1 || matrix.getColumnDimension() != nCols) {
            throw new InvalidMatrixException("dimensions mismatch: got {0}x{1} but expected {2}x{3}", new Object[]{matrix.getRowDimension(), matrix.getColumnDimension(), 1, nCols});
        }
        for (int i = 0; i < nCols; ++i) {
            this.setEntry(row, i, matrix.getEntry(0, i));
        }
    }

    public RealMatrix getColumnMatrix(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        int nRows = this.getRowDimension();
        RealMatrix out = this.createMatrix(nRows, 1);
        for (int i = 0; i < nRows; ++i) {
            out.setEntry(i, 0, this.getEntry(i, column));
        }
        return out;
    }

    public void setColumnMatrix(int column, RealMatrix matrix) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        int nRows = this.getRowDimension();
        if (matrix.getRowDimension() != nRows || matrix.getColumnDimension() != 1) {
            throw new InvalidMatrixException("dimensions mismatch: got {0}x{1} but expected {2}x{3}", new Object[]{matrix.getRowDimension(), matrix.getColumnDimension(), nRows, 1});
        }
        for (int i = 0; i < nRows; ++i) {
            this.setEntry(i, column, matrix.getEntry(i, 0));
        }
    }

    public RealVector getRowVector(int row) throws MatrixIndexException {
        return new ArrayRealVector(this.getRow(row), false);
    }

    public void setRowVector(int row, RealVector vector) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        int nCols = this.getColumnDimension();
        if (vector.getDimension() != nCols) {
            throw new InvalidMatrixException("dimensions mismatch: got {0}x{1} but expected {2}x{3}", new Object[]{1, vector.getDimension(), 1, nCols});
        }
        for (int i = 0; i < nCols; ++i) {
            this.setEntry(row, i, vector.getEntry(i));
        }
    }

    public RealVector getColumnVector(int column) throws MatrixIndexException {
        return new ArrayRealVector(this.getColumn(column), false);
    }

    public void setColumnVector(int column, RealVector vector) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        int nRows = this.getRowDimension();
        if (vector.getDimension() != nRows) {
            throw new InvalidMatrixException("dimensions mismatch: got {0}x{1} but expected {2}x{3}", new Object[]{vector.getDimension(), 1, nRows, 1});
        }
        for (int i = 0; i < nRows; ++i) {
            this.setEntry(i, column, vector.getEntry(i));
        }
    }

    public double[] getRow(int row) throws MatrixIndexException {
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        int nCols = this.getColumnDimension();
        double[] out = new double[nCols];
        for (int i = 0; i < nCols; ++i) {
            out[i] = this.getEntry(row, i);
        }
        return out;
    }

    public void setRow(int row, double[] array) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkRowIndex((AnyMatrix)this, (int)row);
        int nCols = this.getColumnDimension();
        if (array.length != nCols) {
            throw new InvalidMatrixException("dimensions mismatch: got {0}x{1} but expected {2}x{3}", new Object[]{1, array.length, 1, nCols});
        }
        for (int i = 0; i < nCols; ++i) {
            this.setEntry(row, i, array[i]);
        }
    }

    public double[] getColumn(int column) throws MatrixIndexException {
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        int nRows = this.getRowDimension();
        double[] out = new double[nRows];
        for (int i = 0; i < nRows; ++i) {
            out[i] = this.getEntry(i, column);
        }
        return out;
    }

    public void setColumn(int column, double[] array) throws MatrixIndexException, InvalidMatrixException {
        MatrixUtils.checkColumnIndex((AnyMatrix)this, (int)column);
        int nRows = this.getRowDimension();
        if (array.length != nRows) {
            throw new InvalidMatrixException("dimensions mismatch: got {0}x{1} but expected {2}x{3}", new Object[]{array.length, 1, nRows, 1});
        }
        for (int i = 0; i < nRows; ++i) {
            this.setEntry(i, column, array[i]);
        }
    }

    public abstract double getEntry(int var1, int var2) throws MatrixIndexException;

    public abstract void setEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public abstract void addToEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public abstract void multiplyEntry(int var1, int var2, double var3) throws MatrixIndexException;

    public RealMatrix transpose() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        RealMatrix out = this.createMatrix(nCols, nRows);
        this.walkInOptimizedOrder((RealMatrixPreservingVisitor)new /* Unavailable Anonymous Inner Class!! */);
        return out;
    }

    @Deprecated
    public RealMatrix inverse() throws InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl((RealMatrix)this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.getInverse();
    }

    @Deprecated
    public double getDeterminant() throws InvalidMatrixException {
        return new LUDecompositionImpl((RealMatrix)this, Double.MIN_NORMAL).getDeterminant();
    }

    public boolean isSquare() {
        return this.getColumnDimension() == this.getRowDimension();
    }

    @Deprecated
    public boolean isSingular() {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl((RealMatrix)this, Double.MIN_NORMAL).getSolver();
        }
        return !this.lu.isNonSingular();
    }

    public abstract int getRowDimension();

    public abstract int getColumnDimension();

    public double getTrace() throws NonSquareMatrixException {
        int nCols;
        int nRows = this.getRowDimension();
        if (nRows != (nCols = this.getColumnDimension())) {
            throw new NonSquareMatrixException(nRows, nCols);
        }
        double trace = 0.0;
        for (int i = 0; i < nRows; ++i) {
            trace += this.getEntry(i, i);
        }
        return trace;
    }

    public double[] operate(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nCols) {
            throw MathRuntimeException.createIllegalArgumentException((String)"vector length mismatch: got {0} but expected {1}", (Object[])new Object[]{v.length, nCols});
        }
        double[] out = new double[nRows];
        for (int row = 0; row < nRows; ++row) {
            double sum = 0.0;
            for (int i = 0; i < nCols; ++i) {
                sum += this.getEntry(row, i) * v[i];
            }
            out[row] = sum;
        }
        return out;
    }

    public RealVector operate(RealVector v) throws IllegalArgumentException {
        try {
            return new ArrayRealVector(this.operate(((ArrayRealVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            int nRows = this.getRowDimension();
            int nCols = this.getColumnDimension();
            if (v.getDimension() != nCols) {
                throw MathRuntimeException.createIllegalArgumentException((String)"vector length mismatch: got {0} but expected {1}", (Object[])new Object[]{v.getDimension(), nCols});
            }
            double[] out = new double[nRows];
            for (int row = 0; row < nRows; ++row) {
                double sum = 0.0;
                for (int i = 0; i < nCols; ++i) {
                    sum += this.getEntry(row, i) * v.getEntry(i);
                }
                out[row] = sum;
            }
            return new ArrayRealVector(out, false);
        }
    }

    public double[] preMultiply(double[] v) throws IllegalArgumentException {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (v.length != nRows) {
            throw MathRuntimeException.createIllegalArgumentException((String)"vector length mismatch: got {0} but expected {1}", (Object[])new Object[]{v.length, nRows});
        }
        double[] out = new double[nCols];
        for (int col = 0; col < nCols; ++col) {
            double sum = 0.0;
            for (int i = 0; i < nRows; ++i) {
                sum += this.getEntry(i, col) * v[i];
            }
            out[col] = sum;
        }
        return out;
    }

    public RealVector preMultiply(RealVector v) throws IllegalArgumentException {
        try {
            return new ArrayRealVector(this.preMultiply(((ArrayRealVector)v).getDataRef()), false);
        }
        catch (ClassCastException cce) {
            int nRows = this.getRowDimension();
            int nCols = this.getColumnDimension();
            if (v.getDimension() != nRows) {
                throw MathRuntimeException.createIllegalArgumentException((String)"vector length mismatch: got {0} but expected {1}", (Object[])new Object[]{v.getDimension(), nRows});
            }
            double[] out = new double[nCols];
            for (int col = 0; col < nCols; ++col) {
                double sum = 0.0;
                for (int i = 0; i < nRows; ++i) {
                    sum += this.getEntry(i, col) * v.getEntry(i);
                }
                out[col] = sum;
            }
            return new ArrayRealVector(out);
        }
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int row = 0; row < rows; ++row) {
            for (int column = 0; column < columns; ++column) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int)startRow, (int)endRow, (int)startColumn, (int)endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int row = startRow; row <= endRow; ++row) {
            for (int column = startColumn; column <= endColumn; ++column) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInRowOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int)startRow, (int)endRow, (int)startColumn, (int)endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int row = startRow; row <= endRow; ++row) {
            for (int column = startColumn; column <= endColumn; ++column) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        int rows = this.getRowDimension();
        int columns = this.getColumnDimension();
        visitor.start(rows, columns, 0, rows - 1, 0, columns - 1);
        for (int column = 0; column < columns; ++column) {
            for (int row = 0; row < rows; ++row) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int)startRow, (int)endRow, (int)startColumn, (int)endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int column = startColumn; column <= endColumn; ++column) {
            for (int row = startRow; row <= endRow; ++row) {
                double oldValue = this.getEntry(row, column);
                double newValue = visitor.visit(row, column, oldValue);
                this.setEntry(row, column, newValue);
            }
        }
        this.lu = null;
        return visitor.end();
    }

    public double walkInColumnOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        MatrixUtils.checkSubMatrixIndex((AnyMatrix)this, (int)startRow, (int)endRow, (int)startColumn, (int)endColumn);
        visitor.start(this.getRowDimension(), this.getColumnDimension(), startRow, endRow, startColumn, endColumn);
        for (int column = startColumn; column <= endColumn; ++column) {
            for (int row = startRow; row <= endRow; ++row) {
                visitor.visit(row, column, this.getEntry(row, column));
            }
        }
        return visitor.end();
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor visitor) throws MatrixVisitorException {
        return this.walkInRowOrder(visitor);
    }

    public double walkInOptimizedOrder(RealMatrixChangingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    public double walkInOptimizedOrder(RealMatrixPreservingVisitor visitor, int startRow, int endRow, int startColumn, int endColumn) throws MatrixIndexException, MatrixVisitorException {
        return this.walkInRowOrder(visitor, startRow, endRow, startColumn, endColumn);
    }

    @Deprecated
    public double[] solve(double[] b) throws IllegalArgumentException, InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl((RealMatrix)this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.solve(b);
    }

    @Deprecated
    public RealMatrix solve(RealMatrix b) throws IllegalArgumentException, InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl((RealMatrix)this, Double.MIN_NORMAL).getSolver();
        }
        return this.lu.solve(b);
    }

    @Deprecated
    public void luDecompose() throws InvalidMatrixException {
        if (this.lu == null) {
            this.lu = new LUDecompositionImpl((RealMatrix)this, Double.MIN_NORMAL).getSolver();
        }
    }

    public String toString() {
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        StringBuffer res = new StringBuffer();
        String fullClassName = this.getClass().getName();
        String shortClassName = fullClassName.substring(fullClassName.lastIndexOf(46) + 1);
        res.append(shortClassName).append("{");
        for (int i = 0; i < nRows; ++i) {
            if (i > 0) {
                res.append(",");
            }
            res.append("{");
            for (int j = 0; j < nCols; ++j) {
                if (j > 0) {
                    res.append(",");
                }
                res.append(this.getEntry(i, j));
            }
            res.append("}");
        }
        res.append("}");
        return res.toString();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof RealMatrix)) {
            return false;
        }
        RealMatrix m = (RealMatrix)object;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        if (m.getColumnDimension() != nCols || m.getRowDimension() != nRows) {
            return false;
        }
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                if (this.getEntry(row, col) == m.getEntry(row, col)) continue;
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        int ret = 7;
        int nRows = this.getRowDimension();
        int nCols = this.getColumnDimension();
        ret = ret * 31 + nRows;
        ret = ret * 31 + nCols;
        for (int row = 0; row < nRows; ++row) {
            for (int col = 0; col < nCols; ++col) {
                ret = ret * 31 + (11 * (row + 1) + 17 * (col + 1)) * MathUtils.hash((double)this.getEntry(row, col));
            }
        }
        return ret;
    }
}

