/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.genetics;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.genetics.Chromosome;
import org.apache.commons.math.genetics.GeneticAlgorithm;
import org.apache.commons.math.genetics.MutationPolicy;
import org.apache.commons.math.genetics.RandomKey;

public class RandomKeyMutation
implements MutationPolicy {
    public Chromosome mutate(Chromosome original) {
        if (!(original instanceof RandomKey)) {
            throw MathRuntimeException.createIllegalArgumentException((String)("RandomKeyMutation works only with RandomKeys, got " + original.getClass().getSimpleName()), (Object[])new Object[0]);
        }
        RandomKey originalRk = (RandomKey)original;
        List repr = originalRk.getRepresentation();
        int rInd = GeneticAlgorithm.getRandomGenerator().nextInt(repr.size());
        ArrayList<Double> newRepr = new ArrayList<Double>(repr);
        newRepr.set(rInd, GeneticAlgorithm.getRandomGenerator().nextDouble());
        return originalRk.newFixedLengthChromosome(newRepr);
    }
}

