/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.MathException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverUtils;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.AbstractDistribution;
import org.apache.commons.math.distribution.ContinuousDistribution;

public abstract class AbstractContinuousDistribution
extends AbstractDistribution
implements ContinuousDistribution,
Serializable {
    private static final long serialVersionUID = -38038050983108802L;
    private double solverAbsoluteAccuracy = 1.0E-6;

    protected AbstractContinuousDistribution() {
    }

    public double density(double x) throws MathRuntimeException {
        throw new MathRuntimeException((Throwable)new UnsupportedOperationException(), "This distribution does not have a density function implemented", new Object[0]);
    }

    public double inverseCumulativeProbability(double p) throws MathException {
        if (p < 0.0 || p > 1.0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"{0} out of [{1}, {2}] range", (Object[])new Object[]{p, 0.0, 1.0});
        }
        1 rootFindingFunction = new /* Unavailable Anonymous Inner Class!! */;
        double lowerBound = this.getDomainLowerBound(p);
        double upperBound = this.getDomainUpperBound(p);
        double[] bracket = null;
        try {
            bracket = UnivariateRealSolverUtils.bracket((UnivariateRealFunction)rootFindingFunction, (double)this.getInitialDomain(p), (double)lowerBound, (double)upperBound);
        }
        catch (ConvergenceException ex) {
            if (Math.abs(rootFindingFunction.value(lowerBound)) < this.getSolverAbsoluteAccuracy()) {
                return lowerBound;
            }
            if (Math.abs(rootFindingFunction.value(upperBound)) < this.getSolverAbsoluteAccuracy()) {
                return upperBound;
            }
            throw new MathException((Throwable)ex);
        }
        double root = UnivariateRealSolverUtils.solve((UnivariateRealFunction)rootFindingFunction, (double)bracket[0], (double)bracket[1], (double)this.getSolverAbsoluteAccuracy());
        return root;
    }

    protected abstract double getInitialDomain(double var1);

    protected abstract double getDomainLowerBound(double var1);

    protected abstract double getDomainUpperBound(double var1);

    protected double getSolverAbsoluteAccuracy() {
        return this.solverAbsoluteAccuracy;
    }
}

