/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.complex;

import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.complex.Complex;
import org.apache.commons.math.util.CompositeFormat;

/*
 * Exception performing whole class analysis ignored.
 */
public class ComplexFormat
extends CompositeFormat {
    private static final long serialVersionUID = -3343698360149467646L;
    private static final String DEFAULT_IMAGINARY_CHARACTER = "i";
    private String imaginaryCharacter;
    private NumberFormat imaginaryFormat;
    private NumberFormat realFormat;

    public ComplexFormat() {
        this("i", ComplexFormat.getDefaultNumberFormat());
    }

    public ComplexFormat(NumberFormat format) {
        this("i", format);
    }

    public ComplexFormat(NumberFormat realFormat, NumberFormat imaginaryFormat) {
        this("i", realFormat, imaginaryFormat);
    }

    public ComplexFormat(String imaginaryCharacter) {
        this(imaginaryCharacter, ComplexFormat.getDefaultNumberFormat());
    }

    public ComplexFormat(String imaginaryCharacter, NumberFormat format) {
        this(imaginaryCharacter, format, (NumberFormat)format.clone());
    }

    public ComplexFormat(String imaginaryCharacter, NumberFormat realFormat, NumberFormat imaginaryFormat) {
        this.setImaginaryCharacter(imaginaryCharacter);
        this.setImaginaryFormat(imaginaryFormat);
        this.setRealFormat(realFormat);
    }

    public static Locale[] getAvailableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static String formatComplex(Complex c) {
        return ComplexFormat.getInstance().format((Object)c);
    }

    public StringBuffer format(Complex complex, StringBuffer toAppendTo, FieldPosition pos) {
        pos.setBeginIndex(0);
        pos.setEndIndex(0);
        double re = complex.getReal();
        this.formatDouble(re, this.getRealFormat(), toAppendTo, pos);
        double im = complex.getImaginary();
        if (im < 0.0) {
            toAppendTo.append(" - ");
            this.formatDouble(-im, this.getImaginaryFormat(), toAppendTo, pos);
            toAppendTo.append(this.getImaginaryCharacter());
        } else if (im > 0.0 || Double.isNaN(im)) {
            toAppendTo.append(" + ");
            this.formatDouble(im, this.getImaginaryFormat(), toAppendTo, pos);
            toAppendTo.append(this.getImaginaryCharacter());
        }
        return toAppendTo;
    }

    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer ret = null;
        if (obj instanceof Complex) {
            ret = this.format((Complex)obj, toAppendTo, pos);
        } else if (obj instanceof Number) {
            ret = this.format(new Complex(((Number)obj).doubleValue(), 0.0), toAppendTo, pos);
        } else {
            throw MathRuntimeException.createIllegalArgumentException((String)"cannot format a {0} instance as a complex number", (Object[])new Object[]{obj.getClass().getName()});
        }
        return ret;
    }

    public String getImaginaryCharacter() {
        return this.imaginaryCharacter;
    }

    public NumberFormat getImaginaryFormat() {
        return this.imaginaryFormat;
    }

    public static ComplexFormat getInstance() {
        return ComplexFormat.getInstance((Locale)Locale.getDefault());
    }

    public static ComplexFormat getInstance(Locale locale) {
        NumberFormat f = ComplexFormat.getDefaultNumberFormat((Locale)locale);
        return new ComplexFormat(f);
    }

    public NumberFormat getRealFormat() {
        return this.realFormat;
    }

    public Complex parse(String source) throws ParseException {
        ParsePosition parsePosition = new ParsePosition(0);
        Complex result = this.parse(source, parsePosition);
        if (parsePosition.getIndex() == 0) {
            throw MathRuntimeException.createParseException((int)parsePosition.getErrorIndex(), (String)"unparseable complex number: \"{0}\"", (Object[])new Object[]{source});
        }
        return result;
    }

    public Complex parse(String source, ParsePosition pos) {
        int initialIndex = pos.getIndex();
        this.parseAndIgnoreWhitespace(source, pos);
        Number re = this.parseNumber(source, this.getRealFormat(), pos);
        if (re == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        int startIndex = pos.getIndex();
        char c = this.parseNextCharacter(source, pos);
        int sign = 0;
        switch (c) {
            case '\u0000': {
                return new Complex(re.doubleValue(), 0.0);
            }
            case '-': {
                sign = -1;
                break;
            }
            case '+': {
                sign = 1;
                break;
            }
            default: {
                pos.setIndex(initialIndex);
                pos.setErrorIndex(startIndex);
                return null;
            }
        }
        this.parseAndIgnoreWhitespace(source, pos);
        Number im = this.parseNumber(source, this.getRealFormat(), pos);
        if (im == null) {
            pos.setIndex(initialIndex);
            return null;
        }
        if (!this.parseFixedstring(source, this.getImaginaryCharacter(), pos)) {
            return null;
        }
        return new Complex(re.doubleValue(), im.doubleValue() * (double)sign);
    }

    public Object parseObject(String source, ParsePosition pos) {
        return this.parse(source, pos);
    }

    public void setImaginaryCharacter(String imaginaryCharacter) {
        if (imaginaryCharacter == null || imaginaryCharacter.length() == 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"empty string for imaginary character", (Object[])new Object[0]);
        }
        this.imaginaryCharacter = imaginaryCharacter;
    }

    public void setImaginaryFormat(NumberFormat imaginaryFormat) {
        if (imaginaryFormat == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"null imaginary format", (Object[])new Object[0]);
        }
        this.imaginaryFormat = imaginaryFormat;
    }

    public void setRealFormat(NumberFormat realFormat) {
        if (realFormat == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"null real format", (Object[])new Object[0]);
        }
        this.realFormat = realFormat;
    }
}

