/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.ConvergenceException;
import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolver;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class UnivariateRealSolverUtils {
    private static final String NULL_FUNCTION_MESSAGE = "function is null";

    private UnivariateRealSolverUtils() {
    }

    public static double solve(UnivariateRealFunction f, double x0, double x1) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup((UnivariateRealFunction)f);
        return LazyHolder.access$000().newDefaultSolver().solve(f, x0, x1);
    }

    public static double solve(UnivariateRealFunction f, double x0, double x1, double absoluteAccuracy) throws ConvergenceException, FunctionEvaluationException {
        UnivariateRealSolverUtils.setup((UnivariateRealFunction)f);
        UnivariateRealSolver solver = LazyHolder.access$000().newDefaultSolver();
        solver.setAbsoluteAccuracy(absoluteAccuracy);
        return solver.solve(f, x0, x1);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound) throws ConvergenceException, FunctionEvaluationException {
        return UnivariateRealSolverUtils.bracket((UnivariateRealFunction)function, (double)initial, (double)lowerBound, (double)upperBound, (int)Integer.MAX_VALUE);
    }

    public static double[] bracket(UnivariateRealFunction function, double initial, double lowerBound, double upperBound, int maximumIterations) throws ConvergenceException, FunctionEvaluationException {
        double fb;
        double fa;
        if (function == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"function is null", (Object[])new Object[0]);
        }
        if (maximumIterations <= 0) {
            throw MathRuntimeException.createIllegalArgumentException((String)"bad value for maximum iterations number: {0}", (Object[])new Object[]{maximumIterations});
        }
        if (initial < lowerBound || initial > upperBound || lowerBound >= upperBound) {
            throw MathRuntimeException.createIllegalArgumentException((String)"invalid bracketing parameters:  lower bound={0},  initial={1}, upper bound={2}", (Object[])new Object[]{lowerBound, initial, upperBound});
        }
        double a = initial;
        double b = initial;
        int numIterations = 0;
        do {
            a = Math.max(a - 1.0, lowerBound);
            b = Math.min(b + 1.0, upperBound);
        } while ((fa = function.value(a)) * (fb = function.value(b)) > 0.0 && ++numIterations < maximumIterations && (a > lowerBound || b < upperBound));
        if (fa * fb > 0.0) {
            throw new ConvergenceException("number of iterations={0}, maximum iterations={1}, initial={2}, lower bound={3}, upper bound={4}, final a value={5}, final b value={6}, f(a)={7}, f(b)={8}", new Object[]{numIterations, maximumIterations, initial, lowerBound, upperBound, a, b, fa, fb});
        }
        return new double[]{a, b};
    }

    public static double midpoint(double a, double b) {
        return (a + b) * 0.5;
    }

    private static void setup(UnivariateRealFunction f) {
        if (f == null) {
            throw MathRuntimeException.createIllegalArgumentException((String)"function is null", (Object[])new Object[0]);
        }
    }
}

