/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.solvers;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.DifferentiableUnivariateRealFunction;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverImpl;
import org.apache.commons.math.analysis.solvers.UnivariateRealSolverUtils;

public class NewtonSolver
extends UnivariateRealSolverImpl {
    @Deprecated
    public NewtonSolver(DifferentiableUnivariateRealFunction f) {
        super((UnivariateRealFunction)f, 100, 1.0E-6);
    }

    public NewtonSolver() {
        super(100, 1.0E-6);
    }

    @Deprecated
    public double solve(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, min, max);
    }

    @Deprecated
    public double solve(double min, double max, double startValue) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(this.f, min, max, startValue);
    }

    public double solve(UnivariateRealFunction f, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException {
        return this.solve(f, min, max, UnivariateRealSolverUtils.midpoint((double)min, (double)max));
    }

    public double solve(UnivariateRealFunction f, double min, double max, double startValue) throws MaxIterationsExceededException, FunctionEvaluationException {
        try {
            UnivariateRealFunction derivative = ((DifferentiableUnivariateRealFunction)f).derivative();
            this.clearResult();
            this.verifySequence(min, startValue, max);
            double x0 = startValue;
            for (int i = 0; i < this.maximalIterationCount; ++i) {
                double x1 = x0 - f.value(x0) / derivative.value(x0);
                if (Math.abs(x1 - x0) <= this.absoluteAccuracy) {
                    this.setResult(x1, i);
                    return x1;
                }
                x0 = x1;
            }
            throw new MaxIterationsExceededException(this.maximalIterationCount);
        }
        catch (ClassCastException cce) {
            throw MathRuntimeException.createIllegalArgumentException((String)"function is not differentiable", (Object[])new Object[0]);
        }
    }
}

