/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.analysis.integration;

import org.apache.commons.math.FunctionEvaluationException;
import org.apache.commons.math.MathRuntimeException;
import org.apache.commons.math.MaxIterationsExceededException;
import org.apache.commons.math.analysis.UnivariateRealFunction;
import org.apache.commons.math.analysis.integration.TrapezoidIntegrator;
import org.apache.commons.math.analysis.integration.UnivariateRealIntegratorImpl;

public class RombergIntegrator
extends UnivariateRealIntegratorImpl {
    @Deprecated
    public RombergIntegrator(UnivariateRealFunction f) {
        super(f, 32);
    }

    public RombergIntegrator() {
        super(32);
    }

    @Deprecated
    public double integrate(double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        return this.integrate(this.f, min, max);
    }

    public double integrate(UnivariateRealFunction f, double min, double max) throws MaxIterationsExceededException, FunctionEvaluationException, IllegalArgumentException {
        int m = this.maximalIterationCount + 1;
        double[] previousRow = new double[m];
        double[] currentRow = new double[m];
        this.clearResult();
        this.verifyInterval(min, max);
        this.verifyIterationCount();
        TrapezoidIntegrator qtrap = new TrapezoidIntegrator();
        currentRow[0] = qtrap.stage(f, min, max, 0);
        double olds = currentRow[0];
        for (int i = 1; i <= this.maximalIterationCount; ++i) {
            double rLimit;
            double delta;
            double[] tmpRow = previousRow;
            previousRow = currentRow;
            currentRow = tmpRow;
            currentRow[0] = qtrap.stage(f, min, max, i);
            for (int j = 1; j <= i; ++j) {
                double r = (1L << 2 * j) - 1L;
                double tIJm1 = currentRow[j - 1];
                currentRow[j] = tIJm1 + (tIJm1 - previousRow[j - 1]) / r;
            }
            double s = currentRow[i];
            if (i >= this.minimalIterationCount && ((delta = Math.abs(s - olds)) <= (rLimit = this.relativeAccuracy * (Math.abs(olds) + Math.abs(s)) * 0.5) || delta <= this.absoluteAccuracy)) {
                this.setResult(s, i);
                return this.result;
            }
            olds = s;
        }
        throw new MaxIterationsExceededException(this.maximalIterationCount);
    }

    protected void verifyIterationCount() throws IllegalArgumentException {
        super.verifyIterationCount();
        if (this.maximalIterationCount > 32) {
            throw MathRuntimeException.createIllegalArgumentException((String)"invalid iteration limits: min={0}, max={1}", (Object[])new Object[]{0, 32});
        }
    }
}

