/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.emf.util.ModelContent;

public class ResourceHelper {
    ResourceSet resourceSet = new ResourceSetImpl();

    public void toFile(List<EObject> objs, URI tofile) throws IOException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("ENCODING", "UTF-8");
        for (EObject obj : objs) {
            if (!(obj instanceof EStructuralFeature.Internal.DynamicValueHolder)) continue;
            options.put("SCHEMA_LOCATION", Boolean.TRUE);
        }
        Resource r = this.resourceSet.createResource(tofile);
        try {
            r.getContents().addAll(objs);
        }
        catch (NullPointerException e) {
            e.printStackTrace();
            throw new IOException("Resource saving failed " + tofile.toString());
        }
        r.save(options);
    }

    public ModelContent loadModel(URI uri) throws IOException {
        if (uri == null) {
            return null;
        }
        if (uri.fragment() != null && uri.fragment().length() > 0) {
            EObject eObject = this.resourceSet.getEObject(uri, true);
            if (eObject == null) {
                return null;
            }
            return new ModelContent(Collections.singletonList(eObject));
        }
        Resource resource = this.resourceSet.createResource(uri.trimFragment());
        resource.load(null);
        if (resource == null || resource.getContents().isEmpty()) {
            return null;
        }
        return new ModelContent((List)resource.getContents());
    }

    public List<EObject> fromFile(URI uri) throws IOException {
        IOException e1 = null;
        ModelContent m = null;
        String fileSynchronized = null;
        String fileToSync = null;
        while (true) {
            fileSynchronized = fileToSync;
            try {
                m = this.loadModel(uri);
            }
            catch (IOException e) {
                String msg = e.getMessage();
                if (!msg.startsWith("Resource is out of sync") && !msg.startsWith("The model is not reachable")) {
                    throw e;
                }
                e1 = e;
                fileToSync = msg.replaceAll("^.*'(.+)'.*$", "$1");
            }
            if (m != null) {
                return m.getContent();
            }
            if (fileToSync == null) {
                throw new IOException("The model is empty or doesn't exist (" + uri.toString() + ")");
            }
            if (fileSynchronized == fileToSync) {
                throw e1;
            }
            System.out.println("The file is out of sync (" + fileToSync + ")");
            this.synchronizeResource(fileToSync);
        }
    }

    public boolean existsFile(URI uri) {
        try {
            this.fromFile(uri);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private boolean synchronizeResource(String uri) {
        IPath path = Path.fromPortableString((String)uri);
        SynchMonitor synchMonitor = new SynchMonitor();
        try {
            ResourcesPlugin.getWorkspace().getRoot().getFile(path).refreshLocal(2, (IProgressMonitor)synchMonitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        synchMonitor.waitEnd();
        return true;
    }

    public boolean synchronizeProject(String name) {
        SynchMonitor synchMonitor = new SynchMonitor();
        try {
            ResourcesPlugin.getWorkspace().getRoot().getProject(name).refreshLocal(2, (IProgressMonitor)synchMonitor);
            synchMonitor = new SynchMonitor();
            IPath path = Path.fromPortableString((String)("platform:/resource/" + name + "/"));
            ResourcesPlugin.getWorkspace().getRoot().getFolder(path).refreshLocal(2, (IProgressMonitor)synchMonitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            return false;
        }
        synchMonitor.waitEnd();
        return true;
    }

    class SynchMonitor
    implements IProgressMonitor {
        boolean notified = false;

        SynchMonitor() {
        }

        public void beginTask(String name, int totalWork) {
        }

        public synchronized void done() {
            this.notified = true;
            this.notifyAll();
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public synchronized void setCanceled(boolean value) {
            this.notified = true;
            this.notifyAll();
        }

        public void setTaskName(String name) {
        }

        public void subTask(String name) {
        }

        public void worked(int work) {
        }

        public synchronized void waitEnd() {
            while (!this.notified) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

