/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc;

import eu.qimpress.dtmc.Module;
import eu.qimpress.dtmc.Node;
import eu.qimpress.dtmc.Transition;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcModule;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcNode;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.IDtmcTransition;
import eu.qimpress.ide.analysis.reliability.rmc.importer.dtmc.ModelMap;
import java.util.ArrayList;
import java.util.List;

public class DtmcModule
implements IDtmcModule {
    private Module module;
    private List<IDtmcNode> nodes = null;
    private List<IDtmcTransition> transitions = null;
    private ModelMap map;

    public DtmcModule(ModelMap map, Module module) {
        this.map = map;
        this.module = module;
    }

    @Override
    public String getName() {
        return this.module.getName();
    }

    @Override
    public List<IDtmcTransition> getTransitions() {
        if (this.transitions == null) {
            this.initTransitions();
        }
        return this.transitions;
    }

    @Override
    public List<IDtmcNode> getNodes() {
        if (this.nodes == null) {
            this.initNodes();
        }
        return this.nodes;
    }

    private void initNodes() {
        this.nodes = new ArrayList<IDtmcNode>();
        if (this.module.getNodes() != null) {
            for (Node node : this.module.getNodes()) {
                this.nodes.add(this.map.dtmcNode(node));
            }
        }
    }

    private void initTransitions() {
        this.transitions = new ArrayList<IDtmcTransition>();
        if (this.module.getTransitions() != null) {
            for (Transition transition : this.module.getTransitions()) {
                this.transitions.add(this.map.dtmcTransition(transition));
            }
        }
    }

    @Override
    public boolean isAutonomous() {
        return this.module.isIsAutonomous();
    }
}

