/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.launch;

import de.uka.ipd.sdq.workflow.Blackboard;
import de.uka.ipd.sdq.workflow.BlackboardBasedWorkflow;
import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedLaunchConfigurationDelegate;
import de.uka.ipd.sdq.workflow.launchconfig.AbstractWorkflowBasedRunConfiguration;
import de.uka.ipd.sdq.workflow.launchconfig.LoggerAppenderStruct;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.ui.UIBasedWorkflow;
import eu.qimpress.ide.analysis.reliability.jobs.FillResultsModelJob;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJob;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJobConf;
import eu.qimpress.ide.analysis.reliability.launch.ReliabilityLaunchConfiguration;
import eu.qimpress.samm.usagemodel.UsageScenario;
import eu.qimpress.transformations.common.jobs.LoadResultsModelJob;
import eu.qimpress.transformations.common.jobs.LoadSAMMIntoBlackboardJob;
import eu.qimpress.transformations.common.jobs.PrepareResultsBlackboardPartionJob;
import eu.qimpress.transformations.common.jobs.SAMMValidationJob;
import java.util.ArrayList;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ReliabilityLaunchConfigurationDelegate
extends AbstractWorkflowBasedLaunchConfigurationDelegate<ReliabilityLaunchConfiguration, BlackboardBasedWorkflow<MDSDBlackboard>> {
    private static final String LOG_PATTERN = "%-5p: %m\n";
    private Logger logger = Logger.getLogger(AbstractWorkflowBasedLaunchConfigurationDelegate.class);
    public static final String OAW_SAMM_CHECK_FILE = "reliability";

    protected IJob createWorkflowJob(ReliabilityLaunchConfiguration config, ILaunch launch) throws CoreException {
        OrderPreservingBlackboardCompositeJob rootJob = new OrderPreservingBlackboardCompositeJob();
        rootJob.setName("Reliability Analysis Main Task");
        rootJob.add((IJob)new LoadSAMMIntoBlackboardJob(config.getAlternative()));
        rootJob.add((IJob)new PrepareResultsBlackboardPartionJob());
        rootJob.add((IJob)new LoadResultsModelJob(config.getAlternative()));
        rootJob.add((IJob)new SAMMValidationJob((AbstractWorkflowBasedRunConfiguration)config, new String[]{"samm", OAW_SAMM_CHECK_FILE}));
        for (UsageScenario us : config.getUsageModel().getUsageScenarios()) {
            this.logger.debug((Object)("Creating Analysis Job for usage scenario [" + us.getId() + "]"));
            SysCallAnalysisJob sysCallJob = new SysCallAnalysisJob(ReliabilityLaunchConfigurationDelegate.deriveSysCallAnalysisJobConf(config, us.getId()));
            rootJob.add((IJob)sysCallJob);
            this.logger.debug((Object)"Creating job to fill results model with analysis results...");
            FillResultsModelJob frmJob = new FillResultsModelJob(ReliabilityLaunchConfigurationDelegate.deriveSysCallAnalysisJobConf(config, us.getId()), sysCallJob);
            rootJob.add((IJob)frmJob);
        }
        return rootJob;
    }

    public static SysCallAnalysisJobConf deriveSysCallAnalysisJobConf(ReliabilityLaunchConfiguration config, String usageScenarioId) {
        SysCallAnalysisJobConf conf = new SysCallAnalysisJobConf();
        conf.setDefaults();
        conf.setReliabilityConf(config);
        conf.setUsageScenarioId(usageScenarioId);
        return conf;
    }

    protected UIBasedWorkflow<MDSDBlackboard> createWorkflow(ReliabilityLaunchConfiguration workflowConfiguration, IProgressMonitor monitor, ILaunch launch) throws CoreException {
        return new UIBasedWorkflow(this.createWorkflowJob(workflowConfiguration, launch), monitor, this.createExcpetionHandler(workflowConfiguration.isInteractive()), (Blackboard)new MDSDBlackboard());
    }

    protected ReliabilityLaunchConfiguration deriveConfiguration(ILaunchConfiguration configuration, String mode) throws CoreException {
        ReliabilityLaunchConfiguration config = new ReliabilityLaunchConfiguration();
        config.initializeFrom(configuration);
        if (!config.isValid()) {
            this.throwCoreException(config.getErrorMessage());
        }
        return config;
    }

    protected ArrayList<LoggerAppenderStruct> setupLogging(Level logLevel) throws CoreException {
        ArrayList<LoggerAppenderStruct> loggerList = new ArrayList<LoggerAppenderStruct>();
        loggerList.add(this.setupLogger("de.uka.ipd.sdq.workflow", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("eu.qimpress.ide.analysis.reliability.jobs", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("eu.qimpress.ide.analysis.reliability.jobs.acceleo", logLevel, LOG_PATTERN));
        loggerList.add(this.setupLogger("eu.qimpress.ide.analysis.reliability.jobs.prism", logLevel, LOG_PATTERN));
        return loggerList;
    }

    private void throwCoreException(String message) throws CoreException {
        throw new CoreException((IStatus)new Status(4, "eu.qimpress.ide.reliability", 0, message, null));
    }
}

