/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import de.uka.ipd.sdq.workflow.IJob;
import de.uka.ipd.sdq.workflow.IJobWithResult;
import de.uka.ipd.sdq.workflow.OrderPreservingBlackboardCompositeJob;
import de.uka.ipd.sdq.workflow.exceptions.RollbackFailedException;
import de.uka.ipd.sdq.workflow.exceptions.WorkflowFailedException;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.MDSDBlackboard;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.ModelLocation;
import de.uka.ipd.sdq.workflow.mdsd.blackboard.SavePartitionToDiskJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJob;
import de.uka.ipd.sdq.workflow.mdsd.emf.qvto.QVTOTransformationJobConfiguration;
import eu.qimpress.ide.analysis.reliability.jobs.EmfValidatorHelper;
import eu.qimpress.ide.analysis.reliability.jobs.PrepareReliabilityBlackboardPartitionConf;
import eu.qimpress.ide.analysis.reliability.jobs.PrepareReliabiltyBlackboardPartionJob;
import eu.qimpress.ide.analysis.reliability.jobs.ReliabilityAnalysis;
import eu.qimpress.ide.analysis.reliability.jobs.ReliabilityAnalysisResult;
import eu.qimpress.ide.analysis.reliability.jobs.SysCallAnalysisJobConf;
import eu.qimpress.ide.analysis.reliability.jobs.ValidationException;
import eu.qimpress.ide.analysis.reliability.launch.ReliabilityLaunchConfiguration;
import eu.qimpress.ide.backbone.core.model.IQElement;
import eu.qimpress.ide.backbone.core.model.IQModel;
import eu.qimpress.transformations.common.jobs.LoadSAMMAlternativeJob;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.URI;

public class SysCallAnalysisJob
extends OrderPreservingBlackboardCompositeJob<MDSDBlackboard>
implements IJobWithResult<ReliabilityAnalysisResult> {
    private Logger logger = Logger.getLogger(SysCallAnalysisJob.class);
    private static final int SAMM2KLAPER_PARAM_NUMBER = 6;
    private static final int KLAPER2DTMC_PARAM_NUMBER = 2;
    private static final int DTMCPREP_PARAM_NUMBER = 2;
    private String reliabilityPartitionName;
    private SysCallAnalysisJobConf config;
    private ReliabilityAnalysis reliabilityAnalysis;

    public SysCallAnalysisJob(SysCallAnalysisJobConf config) {
        this.config = config;
        PrepareReliabilityBlackboardPartitionConf prbpConf = new PrepareReliabilityBlackboardPartitionConf();
        prbpConf.setPartitionName(config.getReliabilityConf().getAlternativeId());
        this.reliabilityPartitionName = prbpConf.getPartitionName();
        this.add(new PrepareReliabiltyBlackboardPartionJob(prbpConf));
        QVTOTransformationJob samm2klaperJob = new QVTOTransformationJob(this.createSamm2KlaperConf(config));
        this.add((IJob)samm2klaperJob);
        this.add((IJob)new SavePartitionToDiskJob(this.reliabilityPartitionName));
        QVTOTransformationJob klaper2dtmcJob = new QVTOTransformationJob(this.createKlaper2DtmcConf(config));
        this.add((IJob)klaper2dtmcJob);
        QVTOTransformationJob dtmcPreparationJob = new QVTOTransformationJob(this.createDtmcPreparationConf(config));
        this.add((IJob)dtmcPreparationJob);
        this.add((IJob)new SavePartitionToDiskJob(this.reliabilityPartitionName));
        this.reliabilityAnalysis = new ReliabilityAnalysis(this.getDtmcModelURI(config), config.getReliabilityConf().resultPrecision());
        this.add(this.reliabilityAnalysis);
    }

    private QVTOTransformationJobConfiguration createSamm2KlaperConf(SysCallAnalysisJobConf config) {
        QVTOTransformationJobConfiguration jobConf = new QVTOTransformationJobConfiguration();
        HashMap<String, String> mtOpt = new HashMap<String, String>();
        this.logger.debug((Object)"Samm2Klaper : setting transformation options...");
        mtOpt.put("usageScenarioId", config.getUsageScenarioId());
        ModelLocation[] inoutModels = new ModelLocation[6];
        ReliabilityLaunchConfiguration reliabilityConf = config.getReliabilityConf();
        this.logger.debug((Object)"Samm2Klaper : setting input models...");
        IQModel[] inputModels = new IQModel[]{reliabilityConf.getSammModel(), reliabilityConf.getRepositoryModel(), reliabilityConf.getSeffBehavioralModel(), reliabilityConf.getAnnotationsModel(), reliabilityConf.getUsageProfilesModel()};
        int i = 0;
        while (i < inputModels.length) {
            try {
                new EmfValidatorHelper().validateEObject(inputModels[i].getTopLevelEObject());
            }
            catch (ValidationException e) {
                this.logger.debug((Object)("Invalid SAMM model (" + inputModels[i] + ")"));
                throw new WorkflowFailedException("Invalid SAMM model (" + inputModels[i] + ")", (Exception)e);
            }
            inoutModels[i] = new ModelLocation("eu.qimpress.samm.partition", reliabilityConf.getModelURI(inputModels[i]));
            ++i;
        }
        this.logger.debug((Object)"Samm2Klaper : setting output models...");
        inoutModels[5] = new ModelLocation(this.reliabilityPartitionName, this.getKlaperModelURI(config));
        this.logger.debug((Object)"Samm2Klaper : saving configuration...");
        jobConf.setInoutModels(inoutModels);
        jobConf.setOptions(mtOpt);
        this.logger.debug((Object)"Samm2Klaper : setting traces and script location...");
        URI traceFileURI = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)reliabilityConf.getAlternative()).appendSegment("Samm2Klaper.qvtotrace");
        jobConf.setTraceFileURI(traceFileURI);
        URI tScriptURI = URI.createPlatformPluginURI((String)"eu.qimpress.transformations.reliability.m2m.samm2klaper/transforms/samm2klaper.qvto", (boolean)true);
        jobConf.setScriptFileURI(tScriptURI);
        return jobConf;
    }

    private QVTOTransformationJobConfiguration createKlaper2DtmcConf(SysCallAnalysisJobConf config) {
        QVTOTransformationJobConfiguration jobConf = new QVTOTransformationJobConfiguration();
        HashMap mtOpt = new HashMap();
        this.logger.debug((Object)"Klaper2Dtmc : setting transformation options...");
        ModelLocation[] inoutModels = new ModelLocation[2];
        this.logger.debug((Object)"Klaper2Dtmc : setting input models...");
        inoutModels[0] = new ModelLocation(this.reliabilityPartitionName, this.getKlaperModelURI(config));
        this.logger.debug((Object)"Klaper2Dtmc : setting output models...");
        inoutModels[1] = new ModelLocation(this.reliabilityPartitionName, this.getDtmcModelURI(config));
        this.logger.debug((Object)"Klaper2Dtmc : saving configuration...");
        jobConf.setInoutModels(inoutModels);
        jobConf.setOptions(mtOpt);
        this.logger.debug((Object)"Klaper2Dtmc : setting traces and script location...");
        URI traceFileURI = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)config.getReliabilityConf().getAlternative()).appendSegment("Klaper2Dtmc.qvtotrace");
        jobConf.setTraceFileURI(traceFileURI);
        URI tScriptURI = URI.createPlatformPluginURI((String)"eu.qimpress.transformations.reliability.m2m.klaper2dtmc/transforms/klaper2dtmc.qvto", (boolean)true);
        jobConf.setScriptFileURI(tScriptURI);
        return jobConf;
    }

    private QVTOTransformationJobConfiguration createDtmcPreparationConf(SysCallAnalysisJobConf config) {
        QVTOTransformationJobConfiguration jobConf = new QVTOTransformationJobConfiguration();
        HashMap mtOpt = new HashMap();
        this.logger.debug((Object)"DtmcPreparation : setting transformation options...");
        ModelLocation[] inoutModels = new ModelLocation[2];
        this.logger.debug((Object)"DtmcPreparation : setting input models...");
        inoutModels[0] = new ModelLocation(this.reliabilityPartitionName, this.getDtmcModelURI(config));
        this.logger.debug((Object)"DtmcPreparation : setting output models...");
        inoutModels[1] = new ModelLocation(this.reliabilityPartitionName, this.getDtmcModelURI(config));
        this.logger.debug((Object)"DtmcPreparation : saving configuration...");
        jobConf.setInoutModels(inoutModels);
        jobConf.setOptions(mtOpt);
        this.logger.debug((Object)"DtmcPreparation : setting traces and script location...");
        URI traceFileURI = LoadSAMMAlternativeJob.getURIForQIElement((IQElement)config.getReliabilityConf().getAlternative()).appendSegment("Klaper2Dtmc.qvtotrace");
        jobConf.setTraceFileURI(traceFileURI);
        URI tScriptURI = URI.createPlatformPluginURI((String)"eu.qimpress.transformations.reliability.m2m.dtmcPreparation/transforms/dtmcPreparation.qvto", (boolean)true);
        jobConf.setScriptFileURI(tScriptURI);
        return jobConf;
    }

    private IFolder getLocalOutputFolder(SysCallAnalysisJobConf config) {
        return config.getReliabilityConf().getOutputFolder();
    }

    private URI getKlaperModelURI(SysCallAnalysisJobConf config) {
        return URI.createFileURI((String)this.getLocalOutputFolder(config).getFile("/out.klaper").getLocation().toString());
    }

    private URI getDtmcModelURI(SysCallAnalysisJobConf config) {
        return URI.createFileURI((String)this.getLocalOutputFolder(config).getFile("/out.dtmc").getLocation().toString());
    }

    public ReliabilityAnalysisResult getResult() {
        return this.reliabilityAnalysis.getResult();
    }

    public void rollback(IProgressMonitor monitor) throws RollbackFailedException {
    }

    public SysCallAnalysisJobConf getConfiguration() {
        return this.config;
    }
}

