/*
 * Decompiled with CFR 0.152.
 */
package eu.qimpress.ide.analysis.reliability.jobs;

import eu.qimpress.ide.analysis.reliability.jobs.ValidationException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreValidator;

public class EmfValidatorHelper {
    public void validateEObject(EObject eObject) throws ValidationException {
        if (!this.validateEObjectSyntax(eObject)) {
            throw new ValidationException("Model is not comform to its meta-model");
        }
        List<String> errors = this.validateEObjectSemantic(eObject);
        if (errors.size() > 0) {
            throw new ValidationException("Meta-model constraints check failed (" + errors.size() + ")", errors);
        }
    }

    protected List<String> validateEObjectSemantic(EObject eObject) {
        Diagnostic diagnostic = Diagnostician.INSTANCE.validate(eObject);
        ArrayList<String> errs = new ArrayList<String>();
        if (diagnostic.getSeverity() != 4 && diagnostic.getSeverity() != 2) {
            return errs;
        }
        errs.add(diagnostic.getMessage());
        for (Diagnostic childDiagnostic : diagnostic.getChildren()) {
            switch (childDiagnostic.getSeverity()) {
                case 4: {
                    errs.add(childDiagnostic.getMessage());
                }
                case 2: {
                    errs.add(childDiagnostic.getMessage());
                }
            }
        }
        return errs;
    }

    protected boolean validateEObjectSyntax(EObject eObject) {
        return EcoreValidator.INSTANCE.validate(eObject, null, null);
    }
}

