/*
 * Decompiled with CFR 0.152.
 */
package Jama.examples;

import Jama.EigenvalueDecomposition;
import Jama.LUDecomposition;
import Jama.Matrix;
import Jama.QRDecomposition;
import java.text.DecimalFormat;
import java.util.Date;

/*
 * Exception performing whole class analysis ignored.
 */
public class MagicSquareExample {
    public static Matrix magic(int n) {
        double[][] dArray = new double[n][n];
        if (n % 2 == 1) {
            int n2 = (n + 1) / 2;
            int n3 = n + 1;
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray[j][i] = n * ((j + i + n2) % n) + (j + 2 * i + n3) % n + 1;
                }
            }
        } else if (n % 4 == 0) {
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < n; ++j) {
                    dArray[j][i] = (j + 1) / 2 % 2 == (i + 1) / 2 % 2 ? (double)(n * n - n * j - i) : (double)(n * j + i + 1);
                }
            }
        } else {
            double d;
            int n4;
            int n5;
            int n6 = n / 2;
            int n7 = (n - 2) / 4;
            Matrix matrix = MagicSquareExample.magic((int)n6);
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n6; ++n4) {
                    dArray[n4][n5] = d = matrix.get(n4, n5);
                    dArray[n4][n5 + n6] = d + (double)(2 * n6 * n6);
                    dArray[n4 + n6][n5] = d + (double)(3 * n6 * n6);
                    dArray[n4 + n6][n5 + n6] = d + (double)(n6 * n6);
                }
            }
            for (n5 = 0; n5 < n6; ++n5) {
                for (n4 = 0; n4 < n7; ++n4) {
                    d = dArray[n5][n4];
                    dArray[n5][n4] = dArray[n5 + n6][n4];
                    dArray[n5 + n6][n4] = d;
                }
                for (n4 = n - n7 + 1; n4 < n; ++n4) {
                    d = dArray[n5][n4];
                    dArray[n5][n4] = dArray[n5 + n6][n4];
                    dArray[n5 + n6][n4] = d;
                }
            }
            double d2 = dArray[n7][0];
            dArray[n7][0] = dArray[n7 + n6][0];
            dArray[n7 + n6][0] = d2;
            d2 = dArray[n7][n7];
            dArray[n7][n7] = dArray[n7 + n6][n7];
            dArray[n7 + n6][n7] = d2;
        }
        return new Matrix(dArray);
    }

    private static void print(String string) {
        System.out.print(string);
    }

    public static String fixedWidthDoubletoString(double d, int n, int n2) {
        DecimalFormat decimalFormat = new DecimalFormat();
        decimalFormat.setMaximumFractionDigits(n2);
        decimalFormat.setMinimumFractionDigits(n2);
        decimalFormat.setGroupingUsed(false);
        String string = decimalFormat.format(d);
        while (string.length() < n) {
            string = " " + string;
        }
        return string;
    }

    public static String fixedWidthIntegertoString(int n, int n2) {
        String string = Integer.toString(n);
        while (string.length() < n2) {
            string = " " + string;
        }
        return string;
    }

    public static void main(String[] stringArray) {
        MagicSquareExample.print((String)"\n    Test of Matrix Class, using magic squares.\n");
        MagicSquareExample.print((String)"    See MagicSquareExample.main() for an explanation.\n");
        MagicSquareExample.print((String)"\n      n     trace       max_eig   rank        cond      lu_res      qr_res\n\n");
        Date date = new Date();
        double d = Math.pow(2.0, -52.0);
        for (int i = 3; i <= 32; ++i) {
            MagicSquareExample.print((String)MagicSquareExample.fixedWidthIntegertoString((int)i, (int)7));
            Matrix matrix = MagicSquareExample.magic((int)i);
            int n = (int)matrix.trace();
            MagicSquareExample.print((String)MagicSquareExample.fixedWidthIntegertoString((int)n, (int)10));
            EigenvalueDecomposition eigenvalueDecomposition = new EigenvalueDecomposition(matrix.plus(matrix.transpose()).times(0.5));
            double[] dArray = eigenvalueDecomposition.getRealEigenvalues();
            MagicSquareExample.print((String)MagicSquareExample.fixedWidthDoubletoString((double)dArray[i - 1], (int)14, (int)3));
            int n2 = matrix.rank();
            MagicSquareExample.print((String)MagicSquareExample.fixedWidthIntegertoString((int)n2, (int)7));
            double d2 = matrix.cond();
            MagicSquareExample.print((String)(d2 < 1.0 / d ? MagicSquareExample.fixedWidthDoubletoString((double)d2, (int)12, (int)3) : "         Inf"));
            LUDecomposition lUDecomposition = new LUDecomposition(matrix);
            Matrix matrix2 = lUDecomposition.getL();
            Matrix matrix3 = lUDecomposition.getU();
            int[] nArray = lUDecomposition.getPivot();
            Matrix matrix4 = matrix2.times(matrix3).minus(matrix.getMatrix(nArray, 0, i - 1));
            double d3 = matrix4.norm1() / ((double)i * d);
            MagicSquareExample.print((String)MagicSquareExample.fixedWidthDoubletoString((double)d3, (int)12, (int)3));
            QRDecomposition qRDecomposition = new QRDecomposition(matrix);
            Matrix matrix5 = qRDecomposition.getQ();
            matrix4 = qRDecomposition.getR();
            matrix4 = matrix5.times(matrix4).minus(matrix);
            d3 = matrix4.norm1() / ((double)i * d);
            MagicSquareExample.print((String)MagicSquareExample.fixedWidthDoubletoString((double)d3, (int)12, (int)3));
            MagicSquareExample.print((String)"\n");
        }
        Date date2 = new Date();
        double d4 = (double)(date2.getTime() - date.getTime()) / 1000.0;
        MagicSquareExample.print((String)("\nElapsed Time = " + MagicSquareExample.fixedWidthDoubletoString((double)d4, (int)12, (int)3) + " seconds\n"));
        MagicSquareExample.print((String)"Adios\n");
    }
}

