/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanediting.provider;

import de.fzi.kamp.ui.general.ActivityImageProvider;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.maintainabilitymodel.activity.repository.ComponentActivity;
import de.fzi.maintainabilitymodel.activity.repository.DatatypeActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfaceActivity;
import de.fzi.maintainabilitymodel.activity.repository.InterfacePortActivity;
import de.fzi.maintainabilitymodel.activity.repository.OperationActivity;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractComponent;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareArchitect;
import de.fzi.maintainabilitymodel.workorganisation.SoftwareDeveloper;
import de.fzi.maintainabilitymodel.workorganisation.Team;
import de.fzi.maintainabilitymodel.workorganisation.WorkOrganisationElement;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.OperationSelectionContainer;
import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;

public class WorkPlanTreeLabelProvider
implements ITableLabelProvider,
ITableFontProvider {
    private static final Logger logger = Logger.getLogger(WorkPlanTreeLabelProvider.class);

    public Image getColumnImage(Object element, int columnIndex) {
        if (element instanceof CompositeTask) {
            return null;
        }
        if (columnIndex == 0) {
            return ActivityImageProvider.getImageForActivity(element);
        }
        if (columnIndex == 10) {
            return ActivityImageProvider.getIconForSignatureChange(element);
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ComponentSelectionContainer container;
        if (columnIndex == 0) {
            return "";
        }
        if (element instanceof Workplan) {
            return "Workplan";
        }
        if (element instanceof CompositeTask) {
            switch (columnIndex) {
                case 1: {
                    return "Composite Activity";
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return "";
                }
                case 5: {
                    if (element != null && ((CompositeTask)element).getTaskrationale() != null) {
                        return ((CompositeTask)element).getTaskrationale().getKeyword();
                    }
                    return "?";
                }
                case 6: {
                    return "";
                }
                case 4: {
                    return "";
                }
                case 9: {
                    return "";
                }
            }
        }
        if (element instanceof ComponentActivity) {
            container = (ComponentSelectionContainer)((Activity)element).getSelectioncontainer();
            switch (columnIndex) {
                case 1: {
                    return "Component";
                }
                case 2: {
                    return ((ComponentActivity)element).getComponent().getName();
                }
                case 5: {
                    return ((ComponentActivity)element).getComponent().getName();
                }
                case 6: {
                    if (container != null && container.getBasicActivity() != null) {
                        return container.getBasicActivity().toString();
                    }
                    return "?";
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return "";
                }
                case 9: {
                    AbstractComponent abstractComponent = ((ComponentActivity)element).getComponent();
                    return this.buildWorkorganisationElementString(abstractComponent);
                }
            }
        }
        if (element instanceof InterfacePortActivity) {
            InterfacePortSelectionContainer iportContainer = (InterfacePortSelectionContainer)((Activity)element).getSelectioncontainer();
            switch (columnIndex) {
                case 1: {
                    return "Interface Port";
                }
                case 2: {
                    return iportContainer.getParent().getComponenttype().getName();
                }
                case 3: {
                    return iportContainer.getInterfaceport().getName();
                }
                case 5: {
                    return ((InterfacePortActivity)element).getInterfaceport().getName();
                }
                case 6: {
                    if (iportContainer != null && iportContainer.getBasicActivity() != null) {
                        return iportContainer.getBasicActivity().toString();
                    }
                    return "?";
                }
                case 4: {
                    return "";
                }
                case 9: {
                    return this.handleWOElementsPresentationInLowestAbstractionView(element, iportContainer);
                }
            }
        }
        if (element instanceof OperationActivity) {
            container = (OperationSelectionContainer)((Activity)element).getSelectioncontainer();
            InterfacePortSelectionContainer iportContainer = container.getParent();
            switch (columnIndex) {
                case 1: {
                    return "Operation";
                }
                case 2: {
                    return iportContainer.getParent().getComponenttype().getName();
                }
                case 3: {
                    return iportContainer.getInterfaceport().getName();
                }
                case 5: {
                    return ((OperationActivity)element).getOperation().getName();
                }
                case 6: {
                    if (container != null && container.getBasicActivity() != null) {
                        return container.getBasicActivity().toString();
                    }
                    return "?";
                }
                case 4: {
                    return container.getOperation().getName();
                }
                case 9: {
                    return this.handleWOElementsPresentationInLowestAbstractionView(element, iportContainer);
                }
            }
            return "";
        }
        if (element instanceof DatatypeActivity) {
            container = (DataTypeSelectionContainer)((Activity)element).getSelectioncontainer();
            switch (columnIndex) {
                case 1: {
                    return "Datatype Definition";
                }
                case 2: {
                    return "";
                }
                case 5: {
                    if (element != null && ((DatatypeActivity)element).getDatatype() != null) {
                        return ((DatatypeActivity)element).getDatatype().getName();
                    }
                    return "?";
                }
                case 6: {
                    if (container != null && container.getBasicActivity() != null) {
                        return container.getBasicActivity().toString();
                    }
                    return "?";
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return "";
                }
                case 9: {
                    return "";
                }
            }
        }
        if (element instanceof InterfaceActivity && !(element instanceof InterfacePortActivity)) {
            container = (InterfaceSelectionContainer)((Activity)element).getSelectioncontainer();
            switch (columnIndex) {
                case 1: {
                    return "Interface";
                }
                case 5: {
                    if (element != null && ((InterfaceActivity)element).getAinterface() != null) {
                        return ((InterfaceActivity)element).getAinterface().getName();
                    }
                    return "?";
                }
                case 6: {
                    if (container != null && container.getBasicActivity() != null) {
                        return container.getBasicActivity().toString();
                    }
                    return "?";
                }
                case 2: {
                    return "";
                }
                case 3: {
                    return "";
                }
                case 4: {
                    return "";
                }
                case 9: {
                    return "";
                }
            }
        }
        if (element instanceof Activity) {
            switch (columnIndex) {
                case 7: {
                    return "";
                }
                case 8: {
                    return Double.toString(((Activity)element).getAggregatedTimeEstimate());
                }
            }
        }
        return "";
    }

    public String buildWorkorganisationElementString(AbstractComponent abstractComponent) {
        String WOelementsString = "";
        for (WorkOrganisationElement WOelement : abstractComponent.getWorkorganisationelement()) {
            WOelementsString = WOelementsString.isEmpty() ? String.valueOf(WOelementsString) + WOelement.getName() : String.valueOf(WOelementsString) + ", " + WOelement.getName();
            if (WOelement instanceof Team) {
                WOelementsString = String.valueOf(WOelementsString) + " (Team)";
            }
            if (WOelement instanceof SoftwareDeveloper) {
                WOelementsString = String.valueOf(WOelementsString) + " (Developer)";
            }
            if (!(WOelement instanceof SoftwareArchitect)) continue;
            WOelementsString = String.valueOf(WOelementsString) + " (Architect)";
        }
        return WOelementsString;
    }

    public String handleWOElementsPresentationInLowestAbstractionView(Object element, InterfacePortSelectionContainer iportContainer) {
        return "";
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return element instanceof Activity && property.equals("Accumulated Effort");
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    public Font getFont(Object element, int columnIndex) {
        if (element instanceof CompositeTask) {
            return SurfaceFactory.getFontStyle().getBold("answerStyle");
        }
        return SurfaceFactory.getFontStyle().get("answerStyle");
    }
}

