/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizards;

import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacePortPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import org.apache.log4j.Logger;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class InitialWiazardElementsFactory {
    private static final Logger logger = Logger.getLogger(InitialWiazardElementsFactory.class);
    private static SurfaceFactory factory = new SurfaceFactory();

    public static Table createTableForInterfacePortSelection(Composite container, boolean previousIsComponent) {
        String[] headings = new String[]{};
        headings = previousIsComponent ? new String[]{"!", "Component Name", "Interface Port", "Type", "Basic Activity", "SC?*"} : new String[]{"!", "Interface Name", "Component.Interface Port", "Type", "Basic Activity", "SC?*"};
        return InitialWiazardElementsFactory.createTableWithSignatureChangeAnnotation(container, headings);
    }

    public static Table createTableForOperations(Composite container) {
        String[] headings = new String[]{"!", "Component.Interface Port", "Operation", "Basic Activity", "SC?*"};
        return InitialWiazardElementsFactory.createTableWithSignatureChangeAnnotation(container, headings);
    }

    private static Table createTableWithSignatureChangeAnnotation(Composite container, String[] headings) {
        Table table = factory.createTable(container, 1, headings, 4, true);
        factory.setGrabVerticalForGridData((Control)table, true, 4);
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        Label annotation = new Label(container, 0);
        annotation.setText("* SC = Signature Change");
        return table;
    }

    public static Combo createComboForBasicActivity(BasicActivity previousBasicActivity, Table parentTable, TableItem tableItem, int columnNumber) {
        Combo basicActivityCombo = null;
        switch (previousBasicActivity) {
            case ADD: {
                basicActivityCombo = factory.createCombo(tableItem, new String[]{BasicActivity.ADD.toString()}, parentTable, SelectInterfacePortPage.getBasicActivityColumnNumber());
                break;
            }
            case CHANGE: {
                basicActivityCombo = factory.createCombo(tableItem, new String[]{BasicActivity.ADD.toString(), BasicActivity.CHANGE.toString(), BasicActivity.REMOVE.toString()}, parentTable, SelectInterfacePortPage.getBasicActivityColumnNumber());
                break;
            }
            case REMOVE: {
                basicActivityCombo = factory.createCombo(tableItem, new String[]{BasicActivity.REMOVE.toString()}, parentTable, SelectInterfacePortPage.getBasicActivityColumnNumber());
            }
        }
        return basicActivityCombo;
    }

    public static Combo createPlaceboBasicActivityCombo(Table table, TableItem itemForAssociatedInterface) {
        Combo placeboCombo = new Combo((Composite)table, 8);
        placeboCombo.setItems(new String[]{BasicActivity.REMOVE.toString()});
        placeboCombo.setEnabled(false);
        factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)placeboCombo, SelectInterfacePortPage.getBasicActivityColumnNumber());
        return placeboCombo;
    }

    public static Button createPlaceboSelectionCheckbox(Table table, TableItem itemForAssociatedInterface) {
        Button placeboCheckbox = new Button((Composite)table, 32);
        placeboCheckbox.setEnabled(false);
        placeboCheckbox.setToolTipText("It is unnecessary to choose further activities if the parent is removed");
        factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)placeboCheckbox, SelectInterfacePortPage.getSelectionCheckboxColumnNumber());
        return placeboCheckbox;
    }
}

