/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.InterfaceSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfaceCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfaceComboListener;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectDatatypesPage;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.DataTypeSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.impl.SelectioncontainerFactoryImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;

public class SelectInterfacesPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(SelectInterfacesPage.class);
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private DataTypeSelectionContainer temporaryDataTypeContainer;
    private SurfaceFactory factory = new SurfaceFactory();
    private Map<InterfaceSelectionContainer, InterfaceSelectionContainerDecorator> container2decoratorMap;

    protected SelectInterfacesPage(CompositeTaskDerivationContainer workplanContainer) {
        super("interfacePage");
        this.setTitle("Select Interface Activities");
        this.setDescription("Please chose the interfaces which are affected by the\nyour change request.");
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
        this.container2decoratorMap = new HashMap<InterfaceSelectionContainer, InterfaceSelectionContainerDecorator>();
        this.temporaryDataTypeContainer = SelectioncontainerFactoryImpl.eINSTANCE.createDataTypeSelectionContainer();
    }

    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = this.factory.createCompositeOrGroup(parent, 1, 16384, 1, 0, true, 10, 10);
        Table table = this.factory.createTable(container, 1, new String[]{"!", "Datatype", "Interface", "Basic Activity"}, 4, true);
        this.factory.setGrabVerticalForGridData((Control)table, true, 4);
        if (this.getPreviousPage() instanceof SelectDatatypesPage) {
            for (DataTypeSelectionContainer datatypeContainer : this.workplanContainer.getLastShownDataTypeSelectionContainers()) {
                if (!datatypeContainer.isSelected()) continue;
                TableItem item = new TableItem(table, 0);
                item.setText(1, datatypeContainer.getType().getName());
                this.temporaryDataTypeContainer = datatypeContainer;
                this.createTableForInterfaces((List<InterfaceSelectionContainer>)datatypeContainer.getCompleteInterfaceSelectionContainers(), table);
            }
        } else {
            this.createTableForInterfaces((List<InterfaceSelectionContainer>)this.workplanContainer.getInterfaceSelectionContainers(), table);
        }
        this.setControl((Control)container);
        this.setTitle("Choose your interfaces, please");
        this.getShell().pack();
    }

    private void createTableForInterfaces(List<InterfaceSelectionContainer> interfaceList, Table table) {
        table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        for (InterfaceSelectionContainer ifaceContainer : interfaceList) {
            TableItem item = new TableItem(table, 0);
            item.setText(2, ifaceContainer.getReferencedInterface().getName());
            item.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
            table.getColumn(2).pack();
            table.update();
            Button checkbox = new Button((Composite)table, 32);
            this.setControlWithEditor(table, item, (Control)checkbox, 0);
            checkbox.setToolTipText("Check this, if this interface is affected within the current composite activity.");
            table.getColumn(0).pack();
            table.update();
            Combo combo = new Combo((Composite)table, 8);
            combo.add(BasicActivity.ADD.toString());
            combo.add(BasicActivity.CHANGE.toString());
            combo.setEnabled(false);
            this.setControlWithEditor(table, item, (Control)combo, 3);
            combo.setToolTipText("Please specify the basic activity for this interface.");
            table.getColumn(2).pack();
            table.redraw();
            InterfaceSelectionContainerDecorator decorator = new InterfaceSelectionContainerDecorator(ifaceContainer);
            this.container2decoratorMap.put(ifaceContainer, decorator);
            item.setData((Object)ifaceContainer);
            decorator.setCheckbox(checkbox);
            decorator.setCombo(combo);
            decorator.setTableItem(item);
            this.workplanContainer.getLastShownInterfaceContainers().add((Object)ifaceContainer);
            if (this.getPreviousPage() instanceof SelectDatatypesPage) {
                checkbox.addSelectionListener((SelectionListener)new InterfaceCheckboxListener(decorator, this, this.temporaryDataTypeContainer));
            } else {
                checkbox.addSelectionListener((SelectionListener)new InterfaceCheckboxListener(decorator, this));
            }
            combo.addSelectionListener((SelectionListener)new InterfaceComboListener(this, decorator));
            if (!ifaceContainer.isSelected()) continue;
            checkbox.setSelection(true);
            checkbox.setEnabled(false);
            combo.setText(combo.getItem(0));
        }
    }

    private void setControlWithEditor(Table table, TableItem item, Control control, int column) {
        TableEditor editor = new TableEditor(table);
        editor.grabHorizontal = true;
        editor.grabVertical = true;
        editor.setEditor(control, item, column);
        editor.layout();
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        List selectedInterfaces = this.workplanDerivationManager.getSelectedInterfaces();
        if (selectedInterfaces.isEmpty()) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (InterfaceSelectionContainer interfaceContainer : selectedInterfaces) {
            InterfaceSelectionContainerDecorator selection = this.container2decoratorMap.get(interfaceContainer);
            if (interfaceContainer.getBasicActivity() == null) {
                selection.getTableItem().setBackground(2, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                this.setErrorMessage("If you check a component, you have to choose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            try {
                selection.getTableItem().setBackground(2, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
            }
            catch (Exception e) {
                logger.warn((Object)("Exception during backgroud color setting: " + e.getLocalizedMessage()));
            }
        }
        return checkedAndSelected;
    }
}

