/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.initialderivation;

import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.SurfaceFactory;
import de.fzi.kamp.ui.workplanderivation.data.InterfacePortSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.data.InterfaceSelectionContainerDecorator;
import de.fzi.kamp.ui.workplanderivation.listeners.CheckBoxListenerInterfacePortIfInterfaceBefore;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfacePortCheckBoxListener;
import de.fzi.kamp.ui.workplanderivation.listeners.InterfacePortComboListener;
import de.fzi.kamp.ui.workplanderivation.listeners.SignatureChangeInterfacePortCheckboxListener;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectComponentActivitiesWizardPage;
import de.fzi.kamp.ui.workplanderivation.wizard.initialderivation.SelectInterfacesPage;
import de.fzi.kamp.ui.workplanderivation.wizards.InitialWiazardElementsFactory;
import de.fzi.maintainabilitymodel.architecturemodel.AbstractInterfacePort;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.ComponentSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfacePortSelectionContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.InterfaceSelectionContainer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class SelectInterfacePortPage
extends WizardPage {
    private static final Logger logger = Logger.getLogger(SelectInterfacePortPage.class);
    private static final int COLUMN_SELECTIONCHECKBOX = 0;
    private static final int COLUMN_PREVIOUSELEMENT = 1;
    private static final int COLUMN_INTERFACEPORTNAME = 2;
    private static final int COLUMN_IPTYPE = 3;
    private static final int COLUMN_BASICACTIVITYCOMBO = 4;
    private static final int COLUMN_SIGNATURECHANGE = 5;
    private CompositeTaskDerivationContainer workplanContainer;
    private WorkplanDerivationManager workplanDerivationManager;
    private Composite container;
    private Map<InterfacePortSelectionContainer, InterfacePortSelectionContainerDecorator> container2decoratorMap;
    private Table table;
    private boolean startingPointIsComponent = false;
    private SurfaceFactory factory = new SurfaceFactory();

    public SelectInterfacePortPage(CompositeTaskDerivationContainer workplanContainer) {
        super("Derive Work Plan");
        this.setTitle("Select Interface Port Activities");
        this.workplanContainer = workplanContainer;
        this.workplanDerivationManager = new WorkplanDerivationManager(workplanContainer);
        this.container2decoratorMap = new HashMap<InterfacePortSelectionContainer, InterfacePortSelectionContainerDecorator>();
    }

    public void dispose() {
        this.factory.cleanup();
        super.dispose();
    }

    public void createControl(Composite parent) {
        this.container = this.factory.createCompositeOrGroup(parent, 1, 4, 1, 0, false, 0, 0);
        this.setControl((Control)this.container);
        if (this.getPreviousPage() instanceof SelectComponentActivitiesWizardPage) {
            this.startingPointIsComponent = true;
            this.setDescription("Please check the interface ports which are affected\nby the changes in the previously selected components.");
            if (this.workplanDerivationManager.getSelectedComponents().size() > 0) {
                this.configurePageForInitialComponentsSelection(this.workplanDerivationManager.getSelectedComponents());
            }
        } else {
            this.setDescription("Please check the interface ports which are affected\nby the changes in the previously selected interfaces.");
            if (this.getPreviousPage() instanceof SelectInterfacesPage && this.workplanDerivationManager.getSelectedInterfaces().size() > 0) {
                this.configurePageForInitialInterfacesSelection(this.workplanDerivationManager.getSelectedInterfaces());
            }
        }
        this.getShell().pack();
    }

    private void configurePageForInitialComponentsSelection(List<ComponentSelectionContainer> selectedContainer) {
        this.table = InitialWiazardElementsFactory.createTableForInterfacePortSelection(this.container, true);
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        for (ComponentSelectionContainer componentContainer : selectedContainer) {
            if (!componentContainer.isSelected()) continue;
            LinkedList<AbstractInterfacePort> alreadyDisplayed = new LinkedList<AbstractInterfacePort>();
            for (InterfacePortSelectionContainer interfacePortContainer : componentContainer.getRefinements()) {
                if (alreadyDisplayed.contains(interfacePortContainer.getInterfaceport())) continue;
                alreadyDisplayed.add(interfacePortContainer.getInterfaceport());
                this.createItemForInterfacePort(interfacePortContainer, this.table, componentContainer.getBasicActivity(), false);
            }
        }
        TableColumn[] tableColumnArray = this.table.getColumns();
        int n = tableColumnArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn column = tableColumnArray[n2];
            column.pack();
            ++n2;
        }
        this.table.pack();
        this.setPageComplete(this.checkedAndSelected());
    }

    private void configurePageForInitialInterfacesSelection(List<InterfaceSelectionContainer> interfaceContainers) {
        this.table = InitialWiazardElementsFactory.createTableForInterfacePortSelection(this.container, false);
        EList lastShownInterfaceContainers = this.workplanContainer.getLastShownInterfaceContainers();
        if (lastShownInterfaceContainers.size() > 0) {
            for (InterfaceSelectionContainer ifaceContainer : interfaceContainers) {
                if (!ifaceContainer.isSelected()) continue;
                for (InterfacePortSelectionContainer interfacePort : ifaceContainer.getFollowups()) {
                    this.createItemForInterfacePort(interfacePort, this.table, ifaceContainer.getBasicActivity(), true);
                }
            }
            TableColumn[] tableColumnArray = this.table.getColumns();
            int n = tableColumnArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object column = tableColumnArray[n2];
                column.pack();
                ++n2;
            }
            this.table.pack();
        }
        this.setPageComplete(this.checkedAndSelected());
    }

    private void createItemForInterfacePort(InterfacePortSelectionContainer ifacePortContainer, Table table, BasicActivity basicActivity, boolean changeInterface) {
        this.table.addListener(41, new Listener(){

            public void handleEvent(Event event) {
                event.height = 25;
            }
        });
        TableItem itemForAssociatedInterface = new TableItem(table, 0);
        itemForAssociatedInterface.setFont(SurfaceFactory.getFontStyle().get("answerStyle"));
        this.setStartingPointDependentInformation(itemForAssociatedInterface, ifacePortContainer);
        if (basicActivity != BasicActivity.REMOVE) {
            this.setGeneralFieldsForTableItem(ifacePortContainer, table, basicActivity, changeInterface, itemForAssociatedInterface);
        } else {
            Button placeboCheckbox = InitialWiazardElementsFactory.createPlaceboSelectionCheckbox(table, itemForAssociatedInterface);
            Combo placeboCombo = InitialWiazardElementsFactory.createPlaceboBasicActivityCombo(table, itemForAssociatedInterface);
            Button signatureChangeCheckbox = new Button((Composite)table, 32);
            signatureChangeCheckbox.setEnabled(false);
            this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)signatureChangeCheckbox, 5);
            ifacePortContainer.setBasicActivity(BasicActivity.REMOVE);
            ifacePortContainer.setSelected(true);
            InterfacePortSelectionContainerDecorator decorator = this.createDecorator(ifacePortContainer, itemForAssociatedInterface, placeboCheckbox, placeboCombo, signatureChangeCheckbox);
            this.checkWhetherAlreadyChosen(decorator);
            this.checkedAndSelected();
        }
    }

    private void setStartingPointDependentInformation(TableItem itemForAssociatedInterface, InterfacePortSelectionContainer ifacePortContainer) {
        if (this.startingPointIsComponent) {
            itemForAssociatedInterface.setText(1, ifacePortContainer.getParent().getComponenttype().getName());
            itemForAssociatedInterface.setText(2, ifacePortContainer.getInterfaceport().getName());
        } else {
            itemForAssociatedInterface.setText(1, ifacePortContainer.getInterfaceSelectionContainer().getReferencedInterface().getName());
            itemForAssociatedInterface.setText(2, String.valueOf(ifacePortContainer.getParent().getComponenttype().getName()) + "." + ifacePortContainer.getInterfaceport().getName());
        }
    }

    private void setGeneralFieldsForTableItem(InterfacePortSelectionContainer ifacePortContainer, Table table, BasicActivity basicActivity, boolean changeInterface, TableItem itemForAssociatedInterface) {
        Button selectionCheckbox = new Button((Composite)table, 32);
        this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)selectionCheckbox, 0);
        Combo combo = InitialWiazardElementsFactory.createComboForBasicActivity(basicActivity, table, itemForAssociatedInterface, 4);
        combo.setEnabled(false);
        Button signatureChangeCheckbox = new Button((Composite)table, 32);
        signatureChangeCheckbox.setEnabled(false);
        this.factory.setControlWithTableEditor(table, itemForAssociatedInterface, (Control)signatureChangeCheckbox, 5);
        if (ifacePortContainer.getInterfaceport().isRequired()) {
            itemForAssociatedInterface.setText(3, "required");
        } else {
            itemForAssociatedInterface.setText(3, "provided");
        }
        InterfacePortSelectionContainerDecorator decorator = this.createDecorator(ifacePortContainer, itemForAssociatedInterface, selectionCheckbox, combo, signatureChangeCheckbox);
        if (this.getPreviousPage() instanceof SelectComponentActivitiesWizardPage) {
            selectionCheckbox.addSelectionListener((SelectionListener)new InterfacePortCheckBoxListener(this, decorator));
        } else {
            selectionCheckbox.addSelectionListener((SelectionListener)new CheckBoxListenerInterfacePortIfInterfaceBefore(this, decorator));
        }
        combo.addSelectionListener((SelectionListener)new InterfacePortComboListener(this, decorator, changeInterface));
        signatureChangeCheckbox.addSelectionListener((SelectionListener)new SignatureChangeInterfacePortCheckboxListener(decorator));
        this.checkWhetherAlreadyChosen(decorator);
    }

    private InterfacePortSelectionContainerDecorator createDecorator(InterfacePortSelectionContainer ifaceContainer, TableItem itemForAssociatedInterface, Button checkbox, Combo combo, Button signatureChangeCheckbox) {
        InterfacePortSelectionContainerDecorator decorator = new InterfacePortSelectionContainerDecorator(ifaceContainer);
        this.container2decoratorMap.put(ifaceContainer, decorator);
        itemForAssociatedInterface.setData((Object)ifaceContainer);
        decorator.setCheckbox(checkbox);
        decorator.setCombo(combo);
        decorator.setTableItem(itemForAssociatedInterface);
        decorator.setSignatureChangeCheckbox(signatureChangeCheckbox);
        this.workplanDerivationManager.addShowedInterfacePort(ifaceContainer);
        return decorator;
    }

    public void disposeOfAll(Table table) {
        TableItem[] tableItemArray = table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (item.getData() != null) {
                ((InterfaceSelectionContainerDecorator)item.getData()).getCheckbox().dispose();
                ((InterfaceSelectionContainerDecorator)item.getData()).getCombo().dispose();
            } else {
                table.removeAll();
            }
            ++n2;
        }
    }

    public boolean checkedAndSelected() {
        this.setErrorMessage(null);
        if (this.checkWhetherOnlyRemoveActions()) {
            return true;
        }
        List selectedItems = this.workplanDerivationManager.getSelectedInterfacePorts();
        if (selectedItems.size() < 1) {
            return false;
        }
        boolean checkedAndSelected = true;
        for (InterfacePortSelectionContainer abstractContainer : selectedItems) {
            if (abstractContainer.getBasicActivity() == BasicActivity.REMOVE) {
                return true;
            }
            InterfacePortSelectionContainerDecorator decorator = this.container2decoratorMap.get(abstractContainer);
            if (abstractContainer.getBasicActivity() == null) {
                decorator.getTableItem().setBackground(4, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 0, 0, "red"));
                this.setErrorMessage("If you check a component, you have to chose a basic activity");
                checkedAndSelected = false;
                continue;
            }
            decorator.getTableItem().setBackground(4, this.factory.lookupColor(this.getContainer().getShell().getDisplay(), 255, 255, 255, "white"));
        }
        return checkedAndSelected;
    }

    private boolean checkWhetherOnlyRemoveActions() {
        for (ComponentSelectionContainer container : this.workplanContainer.getLastShownComponentContainers()) {
            if (container.getBasicActivity() == BasicActivity.REMOVE || container.getBasicActivity() == null) continue;
            return false;
        }
        for (ComponentSelectionContainer container : this.workplanContainer.getLastShownInterfaceContainers()) {
            if (container.getBasicActivity() == BasicActivity.REMOVE || container.getBasicActivity() == null) continue;
            return false;
        }
        return true;
    }

    private void checkWhetherAlreadyChosen(InterfacePortSelectionContainerDecorator portDecorator) {
        if (portDecorator.getContainer().isSelected()) {
            portDecorator.getCheckbox().setSelection(true);
            portDecorator.getCheckbox().setEnabled(false);
            portDecorator.getCombo().setText(((AbstractContainer)portDecorator.getTableItem().getData()).getBasicActivity().toString());
        }
    }

    public static int getBasicActivityColumnNumber() {
        return 4;
    }

    public static int getSelectionCheckboxColumnNumber() {
        return 0;
    }
}

