/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation;

import de.fzi.kamp.service.maineditor.IMainEditor;
import de.fzi.kamp.service.workplanmanagement.ActivityCreationSwitch;
import de.fzi.kamp.service.workplanmanagement.AdaptationInsertingSwitch;
import de.fzi.kamp.service.workplanmanagement.AdaptationRemovalSwitch;
import de.fzi.kamp.service.workplanmanagement.WorkplanDerivationManager;
import de.fzi.kamp.ui.general.AbstractWizard;
import de.fzi.kamp.ui.maineditor.page.CentralEditorPage;
import de.fzi.kamp.ui.workplanderivation.wizard.furtherderivation.pages.SelectElementTypesPage;
import de.fzi.maintainabilitymodel.workplan.Activity;
import de.fzi.maintainabilitymodel.workplan.CompositeTask;
import de.fzi.maintainabilitymodel.workplan.Task;
import de.fzi.maintainabilitymodel.workplan.Workplan;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.AbstractContainer;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.BasicActivity;
import de.fzi.maintainabilitymodel.workplan.selectioncontainer.CompositeTaskDerivationContainer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class FurtherDerivationWizard
extends AbstractWizard
implements IWizard {
    private static final Logger logger = Logger.getLogger(FurtherDerivationWizard.class);
    public static final int NORMAL_DERIVATION = 0;
    public static final int COMPONENT_DERIVATION = 1;
    public static final int INTERFACE_DERIVATION = 2;
    public static final int DATATYPE_DERIVATION = 3;
    private CompositeTaskDerivationContainer compositeTaskContainer;
    private WorkplanDerivationManager workplanManager;
    private SelectElementTypesPage selectionPage;
    private IMainEditor editor;
    private Tree workplanTree;
    private boolean canFinish = false;
    private Activity activity;
    private List<AbstractContainer> input;

    public FurtherDerivationWizard(Tree workplanTree, IMainEditor editor) {
        this.editor = editor;
        this.selectionPage = new SelectElementTypesPage();
        this.workplanTree = workplanTree;
        TreeItem item = this.workplanTree.getSelection()[0];
        this.activity = (Activity)item.getData();
        if (workplanTree.getData() instanceof Workplan) {
            CompositeTask compositeTask = this.getCompositeTask(this.activity);
            this.compositeTaskContainer = (CompositeTaskDerivationContainer)compositeTask.getSelectioncontainer();
            this.workplanManager = new WorkplanDerivationManager(this.compositeTaskContainer);
        }
        this.input = new ArrayList<AbstractContainer>();
        this.input.add(this.getSelectedContainer());
    }

    @Override
    public boolean performFinish() {
        Map<TreeItem, Button> treeItemToCheckboxMap = this.selectionPage.getTreeItemTocheckboxMap();
        ActivityCreationSwitch activityCreationSwitch = new ActivityCreationSwitch();
        AdaptationInsertingSwitch adaptationInsertingSwitch = new AdaptationInsertingSwitch();
        AdaptationRemovalSwitch adaptationRemovalSwitch = new AdaptationRemovalSwitch();
        LinkedList<TreeItem> allTreeItems = new LinkedList<TreeItem>();
        this.getAllTreeItems(this.selectionPage.getChangeSelectionTree().getItems(), allTreeItems);
        for (TreeItem treeItem : allTreeItems) {
            if (treeItem.getData() instanceof CompositeTaskDerivationContainer) continue;
            if (treeItemToCheckboxMap.get(treeItem).getSelection() && ((AbstractContainer)treeItem.getData()).getActivity() == null) {
                Activity activityToInsert = (Activity)activityCreationSwitch.doSwitch((EObject)((AbstractContainer)treeItem.getData()));
                adaptationInsertingSwitch.setActivityToInsert(activityToInsert);
                AbstractContainer parentSelectionContainer = (AbstractContainer)activityToInsert.getSelectioncontainer().eContainer();
                if (parentSelectionContainer.getActivity() == null) {
                    parentSelectionContainer.setBasicActivity(BasicActivity.CHANGE);
                    activityCreationSwitch.doSwitch((EObject)parentSelectionContainer);
                }
                adaptationInsertingSwitch.doSwitch((EObject)parentSelectionContainer.getActivity());
                continue;
            }
            if (((AbstractContainer)treeItem.getData()).getActivity() == null || treeItemToCheckboxMap.get(treeItem).getSelection()) continue;
            adaptationRemovalSwitch.setActivitytoremove((Object)((AbstractContainer)treeItem.getData()).getActivity());
            adaptationRemovalSwitch.doSwitch(((AbstractContainer)treeItem.getData()).getActivity().eContainer());
        }
        TreeViewer treeViewer = ((CentralEditorPage)this.editor.getCentralPage()).getWorkplanLayer().getAdapter().getTreeViewer(this.workplanTree);
        treeViewer.refresh();
        return true;
    }

    @Override
    public void addPages() {
        this.addPage((IWizardPage)this.selectionPage);
        this.setWindowTitle("Select further Work Activities");
    }

    public AbstractContainer getSelectedContainer() {
        if (this.activity instanceof CompositeTask) {
            return this.compositeTaskContainer;
        }
        return this.workplanManager.getContainerForTask(this.activity);
    }

    public Task getSelectedTask() {
        return (Task)this.workplanTree.getSelection()[0].getData();
    }

    public CompositeTask getCompositeTask(Activity activity) {
        Activity currentActivity = activity;
        while (!(currentActivity instanceof CompositeTask)) {
            currentActivity = (Activity)currentActivity.eContainer();
        }
        return (CompositeTask)currentActivity;
    }

    public List<AbstractContainer> getInput() {
        return this.input;
    }

    @Override
    public boolean canFinish() {
        return this.canFinish;
    }

    public void setCanFinish(boolean canFinish) {
        this.canFinish = canFinish;
    }

    public void getAllTreeItems(TreeItem[] treeItems, List<TreeItem> foundTreeItems) {
        TreeItem[] treeItemArray = treeItems;
        int n = treeItems.length;
        int n2 = 0;
        while (n2 < n) {
            TreeItem treeItem = treeItemArray[n2];
            foundTreeItems.add(treeItem);
            if (treeItem.getItems().length > 0) {
                this.getAllTreeItems(treeItem.getItems(), foundTreeItems);
            }
            ++n2;
        }
    }
}

