/*
 * Decompiled with CFR 0.152.
 */
package de.fzi.kamp.ui.workplanderivation.wizard.calculatefollowupswizard.switches;

import eu.qimpress.samm.staticstructure.ComponentEndpoint;
import eu.qimpress.samm.staticstructure.ComponentType;
import eu.qimpress.samm.staticstructure.CompositeStructure;
import eu.qimpress.samm.staticstructure.Connector;
import eu.qimpress.samm.staticstructure.EndPoint;
import eu.qimpress.samm.staticstructure.InterfacePort;
import eu.qimpress.samm.staticstructure.SubcomponentEndpoint;
import eu.qimpress.samm.staticstructure.util.StaticstructureSwitch;
import java.util.LinkedList;
import java.util.List;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;

public class ConnectedComponentSearchingSwitch
extends StaticstructureSwitch<Object> {
    private static final Logger logger = Logger.getLogger(ConnectedComponentSearchingSwitch.class);
    private List<ComponentType> connectedComponentsList = new LinkedList<ComponentType>();
    private boolean foundConsideredComponent = false;
    private ComponentType consideredComponent;
    private boolean isFirstEndpoint = false;
    private EndPoint firstEndPoint = null;
    private EndPoint secondEndPoint = null;

    public ConnectedComponentSearchingSwitch(ComponentType consideredComponent) {
        this.consideredComponent = consideredComponent;
    }

    public Object caseCompositeStructure(CompositeStructure compositeStructure) {
        for (Connector connector : compositeStructure.getConnector()) {
            this.foundConsideredComponent = false;
            int index = 0;
            for (EndPoint endPoint : connector.getEndpoints()) {
                if (index == 0) {
                    this.firstEndPoint = endPoint;
                } else {
                    this.secondEndPoint = endPoint;
                }
                ++index;
            }
            this.isFirstEndpoint = true;
            this.doSwitch((EObject)this.firstEndPoint);
            if (this.foundConsideredComponent) continue;
            this.isFirstEndpoint = false;
            this.doSwitch((EObject)this.secondEndPoint);
        }
        return compositeStructure;
    }

    public Object caseComponentEndpoint(ComponentEndpoint componentEndpoint) {
        if (!this.foundConsideredComponent) {
            if (!((InterfacePort)componentEndpoint.getPort()).isRequired() && ((InterfacePort)componentEndpoint.getPort()).getProvidingComponentType() == this.consideredComponent) {
                this.foundConsideredComponent = true;
                this.doSwitch((EObject)this.getComplementaryEndpoint().getPort());
            }
        } else {
            this.connectedComponentsList.add((ComponentType)((InterfacePort)componentEndpoint.getPort()).getProvidingComponentType());
        }
        return componentEndpoint;
    }

    public Object caseSubcomponentEndpoint(SubcomponentEndpoint subcomponentEndpoint) {
        if (!this.foundConsideredComponent) {
            if (!((InterfacePort)subcomponentEndpoint.getPort()).isRequired() && subcomponentEndpoint.getSubcomponent().getRealizedBy() == this.consideredComponent) {
                this.foundConsideredComponent = true;
                this.doSwitch((EObject)this.getComplementaryEndpoint());
            }
        } else {
            this.connectedComponentsList.add(subcomponentEndpoint.getSubcomponent().getRealizedBy());
        }
        return subcomponentEndpoint;
    }

    public List<ComponentType> getConnectedComponentsList() {
        return this.connectedComponentsList;
    }

    private EndPoint getComplementaryEndpoint() {
        if (this.isFirstEndpoint) {
            return this.secondEndPoint;
        }
        return this.firstEndPoint;
    }
}

